% type [color] = func_color in main script
% type ,'-+','Color', color.grey43 in the plot command

function [color,colorVec2] = func_color

    sf = 1/255;

    % http://www.fifi.org/doc/wwwcount/Count2.5/rgb.txt.html
    
    % general colors
    color.red = sf*[255 0 0];
    color.orange = sf*[255 140 0]; % DarkOrange
    color.yellow = sf*[255 255 0];
    color.green = sf*[50 205 50]; % LimeGreen 
    color.green = sf*[46 139 87]; % SeaGreen
    color.blue = sf*[0 0 255];
    color.lightBlue = sf*[30 144 255]; % DodgerBlue1
    color.magenta = sf*[255 0 255];
    color.cyan3 = sf*[0 205 205];
    color.white = sf*[255 255 255];
    color.blueViolet = sf*[138 43 226];
    color.darkViolet = sf*[148 0 211];
    color.purple = sf*[160 32 240];
    
    % black
    color.black = sf*[0 0 0];
    
    % greys
    color.grey43 = sf*[110,110,110]; 
    color.grey49 = sf*[200,200,200]; % Default grid colour in matlab
    
    % Color vec for for loop plots 
    % {red,green,blue,grey,...
     % red,green,blue,grey} 
    colorVec = {sf*[255 0 0], sf*[46 139 87], sf*[0 0 255], sf*[200 200 200],...
        sf*[255 0 0], sf*[46 139 87], sf*[0 0 255], sf*[200 200 200]};
    colorVec2 = {sf*[46 139 87], sf*[160 32 240], sf*[0 0 255], sf*[255 0 0],...
        sf*[255 0 0], sf*[46 139 87], sf*[0 0 255], sf*[200 200 200]};
    
end