% Description of function:
% Calculate normalised strain rate
%
% Date - Version - Additions
% 25/02/2020
%
% Notes: 
% Var level swap strainRate.tMaxInd for 
%-------------------------------------------------------------------------%

function [croppedField] = func_cropField(field, grid, smoothingOpts, tMaxInd)

    % Crop fields - pitch+Sk/2, tempSmoothFrames/2+3 (centred finite difference for vel,accel calcs)
    sCrop = floor(grid.pxPerPeriod + smoothingOpts.spatialKernal(1)/2);
    tCrop = floor(smoothingOpts.FFTemporalKernal(1)/2 + 3);  
    croppedField = field(sCrop:end-sCrop, sCrop:end-sCrop, tCrop:tMaxInd-tCrop);    
  
end
