% Description of function:
% Figure dimensions based on different types of figures
%
% Date - Version - Additions
%
% 13/02/2020 - ver 1 - First version. 
% 10/04/2020 - ver 2 - See below: 
% Figure Types: (insert string above func_figureSize. Options:
% ssCurveSubplot1x3
% ssCurveSubplot2x6
% ssCurveSingle
% modulusVsL
% SR_SNorm_VsL_22
% twoWaveAnalysis
%
%--------------------------------------------------------------------------

function [hf] = func_figureSize(hf, figureType, switches)
    
    %----------------------------------------------------------------------
    % Loading pulse
    
    if strcmp('loadingPulse', figureType)
            xaxisScale = 1.8;
            pbaspect([xaxisScale 1 1]);            
            paperWidth = 17; paperHeight = paperWidth/xaxisScale;
            imageWidth=paperWidth*1.0; imageHeight=paperHeight*0.8;
            hf_x0 = -0.5; 
            hf_y0 = 1.0;

    %--------------------------------------------------------------------------
    % SS curves

    elseif strcmp('ssCurveSubplot1x3', figureType)
        if ~switches.singleAxisLabel
            imageWidth = 33; imageHeight = 9;  % Image dimensions
            paperWidth = imageWidth-4; paperHeight = imageHeight;  % Paper dimensions
            hf_x0 = -2.0; 
            hf_y0 = 0.5;
        else
            imageWidth = 33; imageHeight = 9; 
            paperWidth = imageWidth-4; paperHeight = imageHeight; 
            hf_x0 = -2.0; 
            hf_y0 = 0.5;
        end
    elseif strcmp('ssCurveSubplot2x6', figureType)
        if ~switches.singleAxisLabel
            imageWidth = 33; imageHeight = 18;
            paperWidth = imageWidth-4; paperHeight = 17.25;
            hf_x0 = -2.0; 
            hf_y0 = -0.25;
        else
            imageWidth = 33; imageHeight = 19;
            paperWidth = imageWidth-4; paperHeight = imageHeight-2;
            hf_x0 = -2.0; 
            hf_y0 = -1.0;
        end
    elseif strcmp('ssCurveSubplot3x3', figureType)
        imageWidth = 33; imageHeight = 33;
        paperWidth = imageWidth-4; paperHeight = imageHeight-2;
        hf_x0 = -2.0; 
        hf_y0 = -1.0;
    elseif strcmp('ssCurveSingle', figureType)
        imageWidth = 12; imageHeight = 10;
        paperWidth = imageWidth; paperHeight = imageHeight;
        hf_x0 = -0.25; 
        hf_y0 = 0;
            
    %----------------------------------------------------------------------
    % Modulus
    
    elseif strcmp('modulusVsL', figureType)
            xaxisScale = 2.4;
            pbaspect([xaxisScale 1 1]);
            imageWidth = 16; imageHeight = imageWidth/xaxisScale;
            paperWidth = imageWidth*0.95; paperHeight = 0.80*paperWidth/xaxisScale; 
            
            hf_x0 = 0; 
            hf_y0 = 0-0.5;
    
    %----------------------------------------------------------------------
    % Normalised strain rate
    
    elseif strcmp('SR_SNorm_VsL_22', figureType)
            xaxisScale = 2.2;
            pbaspect([xaxisScale 1 1]);
            imageWidth = 20; imageHeight = imageWidth/xaxisScale;
            paperWidth = imageWidth*0.95; paperHeight = 0.88*paperWidth/xaxisScale; 
            
            hf_x0 = 0; 
            hf_y0 = 0-0.6;
            
    %----------------------------------------------------------------------
    % Two-wave analysis
    
    elseif strcmp('twoWaveAnalysis', figureType)
            xaxisScale = 1.8;
            pbaspect([xaxisScale 1 1]);
            imageWidth = 12; imageHeight = imageWidth/xaxisScale;
            paperWidth = imageWidth*0.95; paperHeight = 1.2*(paperWidth/xaxisScale); 
            
            hf_x0 = 0-0.1; 
            hf_y0 = 0+0.5;
    
    %----------------------------------------------------------------------
    
    else 
        fprintf('No figure size parameters defined \n');
    end
    
    %----------------------------------------------------------------------
    % Apply figure paper sizes to the handle
    
    hf = gcf;
    hf.Renderer = 'Painters';
    hf.PaperSize = ([paperWidth,paperHeight]); % Size of paper. note ratio paper/image needs to be constant
    hf.Units = 'centimeters'; 
    hf.PaperUnits = 'centimeters';
    hf.PaperPositionMode = 'manual'; %'auto','manual'.
    hf.PaperPosition = ([hf_x0, hf_y0, imageWidth, imageHeight]); % image size and location
    
    hf.Position = hf.PaperPosition; % Position of figure on screen. export_fig uses this to size png's
    
end