% Description of function:
% Finds the min and max strain thresholds for each slice, for each frame
% Here max and min thresholds are manually set. 
%
% Date - Version - Additions
% 22/07/2019 - Ver1 
% 09/08/2019 - Ver2 - Option to find start and end index based on input fields,
% e.g. strain or stress.
%
% Notes: 
%-------------------------------------------------------------------------%

function [fitFrameRange] = func_fitFrameRangeManual(startIndField, endIndField, minThreshold, maxThreshold, slice, time)

    
    % Find the start index
    for xx = 1:slice.xMaxInd
        startInd(xx) = time.tRange(1); % Define as a vector, not a matrix, starting at the first time range value.
        if minThreshold ~= 0
            for tt = time.tRange(1):time.tRange(end) 
                if abs(startIndField(xx,tt)) > abs(minThreshold)
                startInd(xx) = tt;
                break;
                end
            end
        end
    end

    if isnan(maxThreshold)
        % Find the end index (based on max field value)
        for xx = 1:slice.xMaxInd
            endInd(xx) = time.tRange(end); 
            [~, endInd(xx)] = max(abs(endIndField(xx,:)));
            fitFrameRange{xx} = startInd(xx):endInd(xx);
        end
    else
        % Find the end index
        for xx = 1:slice.xMaxInd
            endInd(xx) = time.tRange(end); 
            for tt = time.tRange(1):time.tRange(end)
                if abs(endIndField(xx,tt)) > abs(maxThreshold)
                    endInd(xx) = tt-1;
                    break
                end
            end
            fitFrameRange{xx} = startInd(xx):endInd(xx); 
        end
    end

end