% Description of function:
% Polynomial fit to thresholded stress-strain data over ALL slices
%
% Author - Sam Parry
%
% Date - Version - Additions
% 22/07/2019 - Ver1 - First version.
%
% Notes: 
%-------------------------------------------------------------------------%

function [ssFitOverLVal, ssFitOverLCoeffs, identStiffThreshOverL] = func_fitStressStrainOverSpecLength(strainVar, stressVar,...
    fitFrameRange, NumberOfSlices);

% Polynomial degree for fit 
polDeg = 1; 

    % Polynomial fit to the thresholded stress-strain curve over ALL slices. p = polyfit(x,y,n)
    for xx = 1:NumberOfSlices
        ssFitOverLCoeffs{xx} = polyfit(strainVar(xx,fitFrameRange{xx}),...
            stressVar(xx,fitFrameRange{xx}), polDeg); % Initiate the variable as a cell
        ssFitOverLVal{xx} = polyval(ssFitOverLCoeffs{xx}, strainVar(xx, fitFrameRange{xx}));  % Fitted y-values for desired x-values.
        identStiffThreshOverL(xx) = ssFitOverLCoeffs{xx}(polDeg);
    end

end