% Description of function:
% Interpolates kinematic fields in material coordinates to an angled slice.
%
% Author - Sam Parry
%
% Date - Version - Additions
% 19/07/2019 - Ver1
% 11/02/2020 - Ver2 removed transpose function for compatibility with IBII
% processing code fields. 
%
%-------------------------------------------------------------------------%

function [e11avgOverL, e22avgOverL, e12avgOverL, Vq_11, Vq_22, Vq_12] = func_interpolateFieldsToSlice(time, pos, strain, slice)

    % Reshape the strain matrices
    temp11 = reshape(strain.mat11,[],time.numFrames);
    temp22 = reshape(strain.mat22,[],time.numFrames); 
    temp12 = reshape(strain.mat12,[],time.numFrames);

    % Interpolate the strains over each Xcoord, for each slice, for each frame.
    for tt=1:time.numFrames
        F_11 = scatteredInterpolant(pos.xGrid(:), pos.yGrid(:), temp11(:,tt));
        F_22 = scatteredInterpolant(pos.xGrid(:), pos.yGrid(:), temp22(:,tt));
        F_12 = scatteredInterpolant(pos.xGrid(:), pos.yGrid(:), temp12(:,tt));
            for ii = 1:slice.xMaxInd
                Vq_11(:,ii,tt) = F_11(slice.Xcoord(ii,:), pos.y);
                Vq_22(:,ii,tt) = F_22(slice.Xcoord(ii,:), pos.y);
                Vq_12(:,ii,tt) = F_12(slice.Xcoord(ii,:), pos.y);
            end
    end
        
    % Strain averages for plotting - Squeeze to get the average down the y-axis.
    e11avgOverL = squeeze(mean(Vq_11));
    e22avgOverL = squeeze(mean(Vq_22));
    e12avgOverL = squeeze(mean(Vq_12));
    
end