% Description of function:
% legend entry manual
%
%-------------------------------------------------------------------------%

function [hl] = func_legendBasic(dataComponent,globalFontSize)


    if strcmp('Slice1_E22',dataComponent) || strcmp('E22',dataComponent)
        
        hl = legend('Ident.','Ident. Avg.','Mean UD45$^{\circ}$','Mean UD90$^{\circ}$','QS Ref.','QS Ref. $\pm$10$\%$');
        
    elseif strcmp('Slice1_G12',dataComponent) || strcmp('Slice2_G12',dataComponent) || strcmp('G12',dataComponent) || strcmp('Slice1_G12_to10me',dataComponent) || strcmp('Slice2_G12_to10me',dataComponent)

        hl = legend('Ident.','Ident. Avg.','Mean UD45$^{\circ}$','Mean UD90$^{\circ}$','QS Ref.','QS Ref. $\pm$10$\%$');

    elseif strcmp('Slice2_E11',dataComponent)

        hl = legend('Ident.','Ident. Avg.','Mean UD90$^{\circ}$','QS Ref.','QS Ref. $\pm$10$\%$');
        
    elseif strcmp('G12_MD45_Slice1',dataComponent) || strcmp('G12_MD45_Slice2',dataComponent)

        hl = legend('Ident.','Ident. Avg.','Mean UD45$^{\circ}$','QS Ref.','QS Ref. $\pm$10$\%$');
        
    elseif strcmp('Exx',dataComponent)

        hl = legend('Ident.','Ident. Mid. 50$\%$','Ident. Avg. Mid. 50$\%$','Mean UD90$^{\circ}$','QS Ref.','QS Ref. $\pm$10$\%$');
        
    elseif strcmp('ExxCorr',dataComponent)

        %hl = legend('Ident.','Ident. Mid. 50$\%$','Ident. Avg. Mid. 50$\%$','Mean UD90$^{\circ}$','QS Ref.','QS Ref. $\pm$10$\%$');
        hl = legend('Ident.','$Q_{12}$ corr. Exp. $\epsilon_{11}$','$Q_{12}$ corr. FE $\epsilon_{11}$','QS Ref.','QS Ref. $\pm$10$\%$');

    elseif strcmp('Gxy',dataComponent)
        
        hl = legend('Ident.','Ident. Mid. 50$\%$','Ident. Avg. Mid. 50$\%$','Mean UD90$^{\circ}$','QS Ref.','QS Ref. $\pm$10$\%$');
    
    
    %----------------------------------------------------------------------
        
    %UD90
    elseif strcmp('UD90_G12_multiple',dataComponent) || strcmp('UD90_E22_multiple',dataComponent)
        
        hl = legend('S1','S2','S3','S4','S5','S6','Ident. Avg','QS Ref.','QS Ref. $\pm$10$\%$');
           
    %UD45
    elseif strcmp('UD45_G12_multiple',dataComponent) || strcmp('UD45_E22_multiple',dataComponent)
        
        hl = legend('S1','S2','S3','S4','S5','S6','S7','Ident. Avg','QS Ref.','QS Ref. $\pm$10$\%$');
               
    %MD45
    elseif strcmp('MD45_G12_multiple',dataComponent)
        
        hl = legend('S1','S2','S3','S4','Ident. Avg','QS Ref.','QS Ref. $\pm$10$\%$');

    %----------------------------------------------------------------------
    % Min avg strain rate vs time

    elseif strcmp('SR_MinAvgVsTime_22',dataComponent)
        
        hl = legend('All slices',...
            'Peak (pre-frac.)');
        
    elseif strcmp('SR_MinAvgVsTime_12',dataComponent)...
        || strcmp('SR_MinAvgVsTime_Slice1_12',dataComponent) || strcmp('SR_MinAvgVsTime_Slice2_12',dataComponent)
        
        hl = legend('All slices',...
            'Peak (pre-frac.)');

    %----------------------------------------------------------------------
    % Min avg strain rate Vs L

    elseif strcmp('SR_MinAvgVsL_22',dataComponent)
        
        hl = legend('Over $E_{22}$ Fit Range',...
            'Ident. Avg');
        
    elseif strcmp('SR_MinAvgVsL_12',dataComponent)...
        || strcmp('SR_MinAvgVsL_Slice1_12',dataComponent) || strcmp('SR_MinAvgVsL_Slice2_12',dataComponent)
        
        hl = legend('Over $G_{12}$ Fit Range',...
            'Ident. Avg');


    %----------------------------------------------------------------------
    % Normalised strain rate

    elseif strcmp('SR_SNorm_VsL_22',dataComponent) 
        
        hl = legend('$ \frac{\sum_{t=1}^{fitRange} \sum_{i=1}^{L} | \dot{\epsilon_{22}} \epsilon_{22}|}  {\sum_{t=1}^{fitRange} \sum_{i=1}^{L} |\epsilon_{22}|}$',...
            'Ident. Avg',...
            'Mid. 50$\%$',...
            'Ident. Avg',...
            '$ \frac{\sum_{t=1}^{Loading} \sum_{i=1}^{Cropped fields} | \dot{\epsilon_{22}} \epsilon_{22}|}  {\sum_{t=1}^{Loading} \sum_{i=1}^{Cropped fields} |\epsilon_{22}|}$');
        
    elseif strcmp('SR_SNorm_VsL_12',dataComponent)
        
        hl = legend('$ \frac{\sum_{t=1}^{fitRange} \sum_{i=1}^{L} | \dot{\gamma_{12}} \gamma_{12}|}  {\sum_{t=1}^{fitRange} \sum_{i=1}^{L} |\gamma_{12}|}$',...
            'Ident. Avg',...
            'Mid. 50$\%$',...
            'Ident. Avg',...
            '$ \frac{\sum_{t=1}^{Loading} \sum_{i=1}^{Cropped fields} | \dot{\gamma_{12}} \gamma_{12}|}  {\sum_{t=1}^{Loading} \sum_{i=1}^{Cropped fields} |\gamma_{12}|}$');

    %---- off-axis required different legend due to all slices used (i.e. no mid 50%)

    elseif strcmp('SR_SNorm_VsL_Slice1_22',dataComponent)
        
        hl = legend('$ \frac{\sum_{t=1}^{fitRange} \sum_{i=1}^{L} | \dot{\epsilon_{22}} \epsilon_{22}|}  {\sum_{t=1}^{fitRange} \sum_{i=1}^{L} |\epsilon_{22}|}$',...
            'Ident. Avg',...
            '$ \frac{\sum_{t=1}^{Loading} \sum_{i=1}^{Cropped fields} | \dot{\epsilon_{22}} \epsilon_{22}|}  {\sum_{t=1}^{Loading} \sum_{i=1}^{Cropped fields} |\epsilon_{22}|}$');
        
    elseif strcmp('SR_SNorm_VsL_Slice1_12',dataComponent) || strcmp('SR_SNorm_VsL_Slice2_12',dataComponent)
        
        hl = legend('$ \frac{\sum_{t=1}^{fitRange} \sum_{i=1}^{L} | \dot{\gamma_{12}} \gamma_{12}|}  {\sum_{t=1}^{fitRange} \sum_{i=1}^{L} |\gamma_{12}|}$',...
            'Ident. Avg',...
            '$ \frac{\sum_{t=1}^{Loading} \sum_{i=1}^{Cropped fields} | \dot{\gamma_{12}} \gamma_{12}|}  {\sum_{t=1}^{Loading} \sum_{i=1}^{Cropped fields} |\gamma_{12}|}$');
    
    %---------------------------------------------------------------------- 
    elseif strcmp('twoWaveAnalysisStrain',dataComponent)
        hl = legend('Transmitted','Incident-reflected');
        hl.Location = 'northeast';
        
    %----------------------------------------------------------------------
    
    else
        fprintf('Legend error')
    end

    % General
    legendFontSize = globalFontSize*0.9;
    hl.FontSize = legendFontSize;
    hl.Interpreter = 'Latex';
    hl.Location = 'eastoutside';

end