% Description of function:
% Calculate normalised strain rate
%
% Date - Version - Additions
% 25/02/2020
%
% Notes: 
% 
%-------------------------------------------------------------------------%

function [normSRComponent] = func_normalisedStrainRate(croppedStrain, croppedStrainRate)

    % Total number of elements in cropped fields
    totalElems = size(croppedStrain, 1)*size(croppedStrain, 2)*size(croppedStrain, 3);
    
    % Vectorise the cropped fields
    tempStrainVec = reshape(croppedStrain, [totalElems,1]);
    tempStrainRateVec = reshape(croppedStrainRate, [totalElems,1]);
    
    % Calculate the normalised strain rate
    normSRComponent = round(sum((abs(tempStrainVec.*tempStrainRateVec))) / sum(abs(tempStrainVec)));
  
end
