% Description of function:
% Normalise the strain rate by the strain, at each slice
%
% Date - Version - Additions
% 26/02/2020
%
% Notes: 
% 
%-------------------------------------------------------------------------%

function [normSR] = func_normalisedStrainRateVsL(fitFrameRange, sliceRangeX, strain, strainRate)
  
    % Initialise
    normSR = zeros(length(sliceRangeX),1);
    
    % Strain rate normalised to strain, for each slice
    for xx = 1:length(sliceRangeX)
        normSR(xx) = sum(sum(abs(strain(:,xx,fitFrameRange{xx}).*strainRate(:,xx,fitFrameRange{xx})))) / sum(sum(abs(strain(:,xx,fitFrameRange{xx}))));
    end

end
