% Description of function:
% Plot minimum average strain rate vs time
%
% Date - Version - Additions
% 28/02/2020
% 16/08/2020 - Added export_fig
%
% Notes:
%
%-------------------------------------------------------------------------%

function [avgPeak] = func_plotMinAvgStrainRateOverTime(strainRateAvg, time, tMaxInd, dataComponent, imageSavePath)

    %----------------------------------------------------------------------
    % Switches
    switches.use_export_fig = true;

    %----------------------------------------------------------------------
    % Min average strain rate vs. time (slice with peak compressive avg sr, for all times)
    AvgStrainRatePeakSliceValue = max(abs(strainRateAvg));
    
    % Min avearge strain rate value (pre frac)
    avgPeak = round(max(AvgStrainRatePeakSliceValue(1:tMaxInd)));
    
    % Figure
    hf = figure;

    % Color generator
    [color] = func_color;

    % Plot
    plot(time.vec*10^6, abs(AvgStrainRatePeakSliceValue), 'k-');
    hold on 
    plot([time.vec(1),time.vec(tMaxInd)*10^6], [avgPeak, avgPeak],'r--');   % Peak value from all 
    hold off

    % Global Font Size
    globalFontSize = 12;
       
    % Legend
    func_legendBasic(dataComponent, globalFontSize);

    % Grid
    grid on
    
    % Axis limits
    func_axisLimits(dataComponent, globalFontSize, time.vec, AvgStrainRatePeakSliceValue);
    
    % axis labels and properties
    func_labelStringGenerator(dataComponent, globalFontSize);
    
    % Figure size
    figureType = 'SR_SNorm_VsL_22';
    func_figureSize(hf, figureType, switches);

    % Set the figure background colour to white
    set(gcf,'color','w');
    
    %----------------------------------------------------------------------
    % Create a new directory to save the results
    savePath = [imageSavePath,'\strainNormalisedStrainRate'];
        if ~exist(savePath,'dir')
            mkdir(savePath);
        end
    addpath(savePath);

    % Save file name
    saveFile = [savePath,'\',dataComponent];

    if switches.use_export_fig
        % Make images using export_fig
        export_fig(saveFile,'-png','-r400','-c[inf,inf,inf,inf]',hf)
    else
        % Make images using the print command
        print(hf,saveFile,'-dpng','-r500'); 
    end

    % Save figure as a mat file
    saveas(hf,saveFile,'fig')
    
end
