% Description of function:
% Plot min avg strain rate vs length
%
% Date - Version - Additions
% 28/02/20
% 16/08/2020 - Added export_fig
%
% Notes:
%
%-------------------------------------------------------------------------%

function [MeanxAvgPeakOverFitRange] = func_plotMinAvgStrainRateVsL(strainRateComponentAvg, sliceRangeX, fitFrameRange, dataComponent, imageSavePath)

    %----------------------------------------------------------------------
    % Switches
    switches.use_export_fig = true;
    
    %----------------------------------------------------------------------
    % Peak avg strain rate per slice, over all frames
    for xx = 1:length(sliceRangeX)
        xAvgPeakOverFitRange(xx) = max(abs(strainRateComponentAvg(xx, fitFrameRange{xx})) );
    end

    % Mean value
    MeanxAvgPeakOverFitRange = round(abs(mean(xAvgPeakOverFitRange)));
        
    % Figure
    hf = figure;

    % Color generator
    [color] = func_color;

    % Plot
    plot(sliceRangeX*10^3, xAvgPeakOverFitRange,'b')
    hold on 
    plot([sliceRangeX(1)*10^3, sliceRangeX(end)*10^3], [MeanxAvgPeakOverFitRange, MeanxAvgPeakOverFitRange],'b--');   % Mean 
    hold off

    % Global Font Size
    globalFontSize = 12;
       
    % Legend
    func_legendBasic(dataComponent, globalFontSize);

    % Grid
    grid on
    
    % Axis limits
    func_axisLimits(dataComponent, globalFontSize, sliceRangeX, xAvgPeakOverFitRange);
    
    % axis labels and properties
    func_labelStringGenerator(dataComponent, globalFontSize);
    
    % Figure size
    figureType = 'SR_SNorm_VsL_22'; 
    func_figureSize(hf, figureType, switches);
    
    % Set the figure background colour to white
    set(gcf,'color','w');
    
    %----------------------------------------------------------------------
    % Create a new directory to save the results
    savePath = [imageSavePath,'\strainNormalisedStrainRate'];
        if ~exist(savePath,'dir')
            mkdir(savePath);
        end
    addpath(savePath);

    % Save file name
    saveFile = [savePath,'\',dataComponent];

    if switches.use_export_fig
        % Make images using export_fig
        export_fig(saveFile,'-png','-r400','-c[inf,inf,inf,inf]',hf)
    else
        % Make images using the print command
        print(hf,saveFile,'-dpng','-r500'); 
    end

    % Save figure as a mat file
    saveas(hf,saveFile,'fig')
end
