% Description of function:
% Progressivly plot the Chord Modulus over the FitFrameRange, for each
% slice.
%
% Date - Version - Additions
% 29/08/2019 - Ver1
%
% 06/02/2020 - Axis limits and save in ssCurves folder
% 06/08/2020 - Updated with export_fig
%
% Notes: 
%-------------------------------------------------------------------------%

function [] = func_plotProgressiveChordModulus(xInd, fitFrameRange, progressiveModulus,...
    meanProgressiveModulus, strainSlice, imageSavePath, dataComponent, slice, linRangeEndInd, ~)
    
    %----------------------------------------------------------------------
    % Switches
    switches.use_export_fig = true;

    %----------------------------------------------------------------------

    % Plot
    hf = figure;
    
    % globalFontSize
    globalFontSize = 15;

    if strcmp('Slice1_progressiveModulus',dataComponent) || strcmp('Slice2_progressiveModulus',dataComponent) || strcmp('progressiveModulus',dataComponent)

        % Plot the progressive chord modulus value vs. time
        plot(strainSlice.avg12(xInd,fitFrameRange{xInd})*10^3, progressiveModulus(xInd,1:length(fitFrameRange{xInd}))*10^-9,'xb-');

        hold on 

        % Plot the mean
        plot([strainSlice.avg12(xInd,fitFrameRange{xInd}(1))*10^3 , strainSlice.avg12(xInd,fitFrameRange{xInd}(end))*10^3],...
            [meanProgressiveModulus(xInd)*10^-9, meanProgressiveModulus(xInd)*10^-9],'r--');

        % Plot the index at the predicted end of the linear range (linRangeEndInd)
        plot([strainSlice.avg12(xInd,linRangeEndInd(xInd))*10^3 , strainSlice.avg12(xInd,linRangeEndInd(xInd))*10^3],...
            [0,meanProgressiveModulus(xInd)*10^-9],'k--');

    elseif strcmp('Slice1_chordModulus',dataComponent) || strcmp('Slice2_chordModulus',dataComponent) || strcmp('chordModulus',dataComponent)

        % Plot the progressive chord modulus value vs. strain
        plot(strainSlice.avg12(xInd,fitFrameRange{xInd})*10^3, progressiveModulus(xInd,1:length(fitFrameRange{xInd}))*10^-9,'xb-');     

        hold on 
        % Plot the mean
        plot([strainSlice.avg12(xInd,fitFrameRange{xInd}(1))*10^3 , strainSlice.avg12(xInd,fitFrameRange{xInd}(end))*10^3],...
            [meanProgressiveModulus(xInd)*10^-9, meanProgressiveModulus(xInd)*10^-9],'r--');        

        % plot the index at the predicted end of the linear range (linRangeEndInd)
        plot([strainSlice.avg12(xInd,linRangeEndInd(xInd))*10^3 , strainSlice.avg12(xInd,linRangeEndInd(xInd))*10^3],...
            [0,meanProgressiveModulus(xInd)*10^-9],'k--');

        % Set the axis limits
        func_axisLimits(dataComponent, globalFontSize);

    end
   
    % Grid
    grid on
    
    % globalFontSize
    globalFontSize = 15;
      
    % Label strings and settings
    func_labelStringGenerator(dataComponent, globalFontSize);
    
    % Title
    titleStrings{1} = (['$x_{0} = \, $',sprintf('%0.1f',slice.slicex0Dist*10^3),' mm']);
    plotProperties.titleFontSize = globalFontSize;
    func_title(titleStrings, plotProperties)  
    
    % Figure Sizing
    figureType = 'ssCurveSingle';  
    func_figureSize(hf, figureType, switches);
    
    % Set the figure background colour to white
    set(gcf,'color','w');
    
    %----------------------------------------------------------------------
    % Create a new directory to save the results
    savePath = [imageSavePath,'\chordFit'];
        if ~exist(savePath,'dir')
            mkdir(savePath);
        end
    addpath(savePath);

    % Save file name
    saveFile = [savePath,'\',dataComponent];

    if switches.use_export_fig
        % Make images using export_fig
        export_fig(saveFile,'-png','-r400','-c[0,0,0,0]',hf)
    else
        % Make images using the print command
        print(hf,saveFile,'-dpng','-r500'); 
    end

    % Save figure as a mat file
     saveas(hf,saveFile,'fig')

end