% Description of function:
% Single stress-strain plot for one slice over the whole loading. Overlay
% the points identified over the linear portion of the curve. 
%
% Date - Version - Additions
% 23/08/2019 - Ver 1
% 06/08/2020 - Updated with export_fig
%
% Notes: Enter distance from free edge x0 that you want the ss curve from.
%-------------------------------------------------------------------------%

function [] = func_plotSSCurveFullandLinearRegion(Strain, Stress, ...
    dataComponent, imageSavePath, slice)
    
    %----------------------------------------------------------------------
    % Switches
    switches.use_export_fig = true;

    %----------------------------------------------------------------------
    % Plot
    hf = figure;
    plot(Strain(slice.xInd,:)*10^3, Stress(slice.xInd,:)*10^-6,'bx-'); 
    hold on
    
    % Overlay the liner region on top
    plot(Strain(slice.xInd, slice.fitRangeLinearRegion{slice.xInd})*10^3,...
    Stress(slice.xInd, slice.fitRangeLinearRegion{slice.xInd})*10^-6,'rx-','LineWidth',1.5); 
    grid on
    hold off
    
    % globalFontSize
    globalFontSize = 15;
    
    % Generate plot parameters
    func_plotSSCurveParameters(dataComponent, slice, globalFontSize);
   
        % Figure Sizing
    figureType = 'ssCurveSingle';  
    func_figureSize(hf, figureType, switches);
    
    %----------------------------------------------------------------------
    % Create a new directory to save the results
    savePath = [imageSavePath,'\chordFit'];
        if ~exist(savePath,'dir')
            mkdir(savePath);
        end
    addpath(savePath);

    % Save file name
    saveFile = [savePath,'\',dataComponent]; %, '.bmp' '.pdf'

    if switches.use_export_fig
        % Make images using export_fig
        export_fig(saveFile,'-png','-r400','-c[0,0,0,0]',hf)
    else
        % Make images using the print command
        print(hf,saveFile,'-dpng','-r500'); 
    end

    % Save figure as a mat file
     saveas(hf,saveFile,'fig')
        
end