% Description of function:
% Generate plot parameters 
%
% Date - Version - Additions
% 17/07/2019 - Ver1 
% 30/08/2019 - Ver2 Includes parameters for ChordE vs. time
% 12/02/2020 - Ver3 slicex0Dist now slice.slicex0Dist to accommodate multi slice
%-------------------------------------------------------------------------%

function [] = func_plotSSCurveParameters(dataComponent, slice, globalFontSize)

    % Figure Properties

    % Title
    ht = title(['$x_{0} = \, $',sprintf('%0.1f',slice.slicex0Dist*10^3),' mm']);
    ht.FontSize = globalFontSize;
    ht.Interpreter = 'Latex';

    % Axis Properties (all)
    ax = gca;
    set(ax,'TickLabelInterpreter','Latex','FontWeight','bold'); 

    % X-axis
    ax.XAxis.FontSize = globalFontSize;

    % X-axis Label
    ax.XLabel.Interpreter = ('Latex');
    ax.XLabel.FontSize = globalFontSize;
    ax.XLabel.FontWeight = 'bold';

    % Y-axis
    ax.YAxis.FontSize = globalFontSize;
    
    % Y-axis Label
    ax.YLabel.Interpreter = ('Latex');
    ax.YLabel.FontSize = globalFontSize;
    ax.YLabel.FontWeight = 'bold';
    
    % Set the figure background colour to white
    set(gcf,'color','w');
    
    %----------------------------------------------------------------------
    
    if strcmp('Slice1_SSCurve_s22',dataComponent)
        ax.YLabel.String = ('Stress, $\overline{\sigma_{22}}^{L}$ (MPa)');
        ax.XLabel.String = ('Strain, $\overline{\epsilon_{22}}^{L}$ (mm.m$^{-1}$)');
%         ax.XAxis.Limits = ([-10 10]);
%         ax.XAxis.TickValues = (-10:5:10);
%         ax.YAxis.Limits = ([-75 50]);
%         ax.YAxis.TickValues = (-75:25:50);

    elseif strcmp('Slice1_SSCurve_s12',dataComponent) || strcmp('Slice2_SSCurve_s12',dataComponent)
        ax.YLabel.String = ('Stress, $\overline{\sigma_{12}}^{L}$ (MPa)');
        ax.XLabel.String = ('Strain, $\overline{\gamma_{12}}^{L}$ (mm.m$^{-1}$)');
%         ax.XAxis.Limits = ([-5 25]);
%         ax.XAxis.TickValues = (-5:5:25);
%         ax.YAxis.Limits = ([-25 100]);
%         ax.YAxis.TickValues = (-25:25:100);

    elseif strcmp('Slice2_SSCurve_s11',dataComponent)
        ax.YLabel.String = ('Stress, $\overline{\sigma_{11}}^{L}$ (MPa)');
        ax.XLabel.String = ('Strain, $\overline{\epsilon_{11}}^{L}$ (mm.m$^{-1}$)');

    elseif strcmp('Slice1_progressiveModulus',dataComponent) || strcmp('Slice2_progressiveModulus',dataComponent)
        ax.YLabel.String = ('Modulus (GPa)');
        %ax.XLabel.String = ('Loading Frame Number');
        ax.XLabel.String = ('Strain, $\overline{\gamma_{12}}^{L}$ (mm.m$^{-1}$)');
        ax.XAxis.Limits = ([0 20]);
        ax.YAxis.Limits = ([4 8]);

    elseif strcmp('Slice1_chordModulus',dataComponent) || strcmp('Slice2_chordModulus',dataComponent)
        ax.YLabel.String = ('Modulus (GPa)');
        ax.XLabel.String = ('Strain, $\overline{\gamma_{12}}^{L}$ (mm.m$^{-1}$)');
        ax.XAxis.Limits = ([0 20]);
        ax.YAxis.Limits = ([4 8]);

    else
        ax.YLabel.String = ('Stress (MPa)');
        ax.XLabel.String = ('Strain (mm/m)');

    end

    if strcmp('Slice1_chordModulus',dataComponent) || strcmp('Slice2_chordModulus',dataComponent)
            % Legend
            hl = legend('Prog. Chord Fit','Avg.','Ident. Lin. Limit');
            hl.FontSize = globalFontSize;
            hl.Interpreter = 'Latex';
            hl.Location = 'northeast';
    end

    if strcmp('Slice1_progressiveModulus',dataComponent) || strcmp('Slice2_progressiveModulus',dataComponent)
            % Legend
            hl = legend('Prog. Linear Fit','Avg.','Ident. Lin. Limit');
            hl.FontSize = globalFontSize;
            hl.Interpreter = 'Latex';
            hl.Location = 'northeast';
    end
        
end