% Description of function:
% Plots stiffness vs length (from thresholded stress-strain curves) for all slices
%
% Date - Version - Additions
% 22/07/2019 - Ver1
% 13/02/2020 - replaced func_plotStiffParameters with individual functions
% axisLimits, labelStringGenerator, figureSize.
%
% Notes:
%
%-------------------------------------------------------------------------%

function [identStiffAvg] = func_plotStiffnessVsL(identStiffThreshOverL,...
    slice, pos, dataComponent, imageSavePath, QS_modulus, plotProperties)

    % switches
    switches.use_export_fig = true;

    % Average Stiffness over threshold range for plotting
    identStiffAvg = mean(identStiffThreshOverL(slice.stiffPlotRangeInd));
    
    % color generator
    [color] = func_color;
       
    % Plot: Stiffness
    hf = figure;
    
    if strcmp('Slice1_E22',dataComponent)
        
        plot(pos.x(slice.stiffPlotRangeInd)*10^3, identStiffThreshOverL(slice.stiffPlotRangeInd)*10^-9, 'ob-');   % Plot fit coefficients to ss curves for each slice over length
        hold on
        plot([0,length(slice.stiffPlotRangeInd)],[identStiffAvg*10^-9, identStiffAvg*10^-9],'b--');   % ([X1,X2],[Y1,Y2]) Ident. Avg
        plot([0,length(slice.stiffPlotRangeInd)],[plotProperties.meanUD90_E22, plotProperties.meanUD90_E22],'red--');   % mean 90 degree tests
        plot([0,length(slice.stiffPlotRangeInd)],[QS_modulus*10^-9, QS_modulus*10^-9],'k--');   % QS ref.
        plot([0,length(slice.stiffPlotRangeInd)],[1.1*QS_modulus*10^-9, 1.1*QS_modulus*10^-9],'k-');   % QS ref. +10% 
        plot([0,length(slice.stiffPlotRangeInd)],[0.9*QS_modulus*10^-9, 0.9*QS_modulus*10^-9],'k-');   % QS ref. -10%
        hold off
        
    elseif strcmp('G12',dataComponent)
        
        plot(pos.x(slice.stiffPlotRangeInd)*10^3, identStiffThreshOverL(slice.stiffPlotRangeInd)*10^-9, 'ob-');   % Plot fit coefficients to ss curves for each slice over length
        hold on
        plot([0,length(slice.stiffPlotRangeInd)],[identStiffAvg*10^-9, identStiffAvg*10^-9],'b--');   % ([X1,X2],[Y1,Y2]) Ident. Avg
        plot([0,length(slice.stiffPlotRangeInd)],[QS_modulus*10^-9, QS_modulus*10^-9],'k--');   % QS ref.
        plot([0,length(slice.stiffPlotRangeInd)],[1.1*QS_modulus*10^-9, 1.1*QS_modulus*10^-9],'k-');   % QS ref. +10% 
        plot([0,length(slice.stiffPlotRangeInd)],[0.9*QS_modulus*10^-9, 0.9*QS_modulus*10^-9],'k-');   % QS ref. -10%
        hold off
        
    elseif strcmp('E22',dataComponent) || strcmp('Slice1_E22',dataComponent)
        
        plot(pos.x(slice.stiffPlotRangeInd)*10^3, identStiffThreshOverL(slice.stiffPlotRangeInd)*10^-9, 'ob-');   % Plot fit coefficients to ss curves for each slice over length
        hold on
        plot([0,length(slice.stiffPlotRangeInd)],[identStiffAvg*10^-9, identStiffAvg*10^-9],'b--');   % ([X1,X2],[Y1,Y2]) Ident. Avg
        plot([0,length(slice.stiffPlotRangeInd)],[plotProperties.meanUD45_E22, plotProperties.meanUD45_E22],'red--');   % mean E22 UD45 tests
        plot([0,length(slice.stiffPlotRangeInd)],[plotProperties.meanUD90_E22, plotProperties.meanUD90_E22],'--','Color', color.green);   % mean UD90 tests
        plot([0,length(slice.stiffPlotRangeInd)],[QS_modulus*10^-9, QS_modulus*10^-9],'k--');   % QS ref.
        plot([0,length(slice.stiffPlotRangeInd)],[1.1*QS_modulus*10^-9, 1.1*QS_modulus*10^-9],'k-');   % QS ref. +10% 
        plot([0,length(slice.stiffPlotRangeInd)],[0.9*QS_modulus*10^-9, 0.9*QS_modulus*10^-9],'k-');   % QS ref. -10%
        hold off
        
    elseif strcmp('G12',dataComponent) || strcmp('Slice1_G12',dataComponent) || strcmp('Slice2_G12',dataComponent)...
        || strcmp('Slice1_G12_to10me',dataComponent) || strcmp('Slice2_G12_to10me',dataComponent)
        
        plot(pos.x(slice.stiffPlotRangeInd)*10^3, identStiffThreshOverL(slice.stiffPlotRangeInd)*10^-9, 'ob-');   % Plot fit coefficients to ss curves for each slice over length
        hold on
        plot([0,length(slice.stiffPlotRangeInd)],[identStiffAvg*10^-9, identStiffAvg*10^-9],'b--');   % ([X1,X2],[Y1,Y2]) Ident. Avg
        plot([0,length(slice.stiffPlotRangeInd)],[plotProperties.meanUD45_G12, plotProperties.meanUD45_G12],'red--');   % mean G12 UD45 tests
        plot([0,length(slice.stiffPlotRangeInd)],[plotProperties.meanUD90_G12, plotProperties.meanUD90_G12],'--','Color', color.green);   % mean G12 UD90 tests
        plot([0,length(slice.stiffPlotRangeInd)],[QS_modulus*10^-9, QS_modulus*10^-9],'k--');   % QS ref.
        plot([0,length(slice.stiffPlotRangeInd)],[1.1*QS_modulus*10^-9, 1.1*QS_modulus*10^-9],'k-');   % QS ref. +10% 
        plot([0,length(slice.stiffPlotRangeInd)],[0.9*QS_modulus*10^-9, 0.9*QS_modulus*10^-9],'k-');   % QS ref. -10%
        hold off
        
    elseif strcmp('Slice2_E11',dataComponent)
        
        plot(pos.x(slice.stiffPlotRangeInd)*10^3, identStiffThreshOverL(slice.stiffPlotRangeInd)*10^-9, 'ob-');   % Plot fit coefficients to ss curves for each slice over length
        hold on
        plot([0,length(slice.stiffPlotRangeInd)],[identStiffAvg*10^-9, identStiffAvg*10^-9],'b--');   % ([X1,X2],[Y1,Y2]) Ident. Avg
        plot([0,length(slice.stiffPlotRangeInd)],[QS_modulus*10^-9, QS_modulus*10^-9],'k--');   % QS ref.
        plot([0,length(slice.stiffPlotRangeInd)],[1.1*QS_modulus*10^-9, 1.1*QS_modulus*10^-9],'k-');   % QS ref. +10% 
        plot([0,length(slice.stiffPlotRangeInd)],[0.9*QS_modulus*10^-9, 0.9*QS_modulus*10^-9],'k-');   % QS ref. -10%
        hold off
        
    elseif strcmp('G12_MD45_Slice1',dataComponent) || strcmp('G12_MD45_Slice2',dataComponent)
        
        plot(pos.x(slice.stiffPlotRangeInd)*10^3, identStiffThreshOverL(slice.stiffPlotRangeInd)*10^-9, 'ob-');   % Plot fit coefficients to ss curves for each slice over length
        hold on
        plot([0,length(slice.stiffPlotRangeInd)],[identStiffAvg*10^-9, identStiffAvg*10^-9],'b--');   % ([X1,X2],[Y1,Y2]) Ident. Avg
        plot([0,length(slice.stiffPlotRangeInd)],[plotProperties.meanUD45_G12, plotProperties.meanUD45_G12],'red--');   % mean 45 UD degree tests
        plot([0,length(slice.stiffPlotRangeInd)],[QS_modulus*10^-9, QS_modulus*10^-9],'k--');   % QS ref.
        plot([0,length(slice.stiffPlotRangeInd)],[1.1*QS_modulus*10^-9, 1.1*QS_modulus*10^-9],'k-');   % QS ref. +10% 
        plot([0,length(slice.stiffPlotRangeInd)],[0.9*QS_modulus*10^-9, 0.9*QS_modulus*10^-9],'k-');   % QS ref. -10%
        hold off
        
    elseif strcmp('Exx',dataComponent)
        
        plot(pos.x*10^3,identStiffThreshOverL*10^-9, 'o-','Color', color.grey43);   % Plot fit coefficients to ss curves for each slice over length
        hold on
        plot(slice.stiffDistanceRangeX*10^3, identStiffThreshOverL(slice.stiffPlotRangeInd)*10^-9, 'ob-');   % Plot fit coefficients to ss curves for each slice over length
        plot([slice.stiffDistanceRangeX(1)*10^3,slice.stiffDistanceRangeX(end)*10^3] , [identStiffAvg*10^-9, identStiffAvg*10^-9],'b--');   % ([X1,X2],[Y1,Y2]) Ident. Avg
        plot([slice.stiffDistanceRangeX(1)*10^3,slice.stiffDistanceRangeX(end)*10^3] , [plotProperties.meanUD90_E22, plotProperties.meanUD90_E22],'red--');   % mean 90 degree tests
        plot([pos.x(1),pos.x(end)*10^3], [QS_modulus*10^-9, QS_modulus*10^-9],'k--');   % QS ref.
        plot([pos.x(1),pos.x(end)*10^3], [1.1*QS_modulus*10^-9, 1.1*QS_modulus*10^-9],'k-');   % QS ref. +10% 
        plot([pos.x(1),pos.x(end)*10^3], [0.9*QS_modulus*10^-9, 0.9*QS_modulus*10^-9],'k-');   % QS ref. -10%
        hold off
        
    elseif strcmp('ExxCorr',dataComponent)
        
        plot(pos.x*10^3,identStiffThreshOverL*10^-9, 'o-','Color', color.grey43);   % Plot fit coefficients to ss curves for each slice over length
        hold on
        plot(slice.stiffDistanceRangeX*10^3, identStiffThreshOverL(slice.stiffPlotRangeInd)*10^-9, 'ob-');   % Plot fit coefficients to ss curves for each slice over length
        plot([slice.stiffDistanceRangeX(1)*10^3,slice.stiffDistanceRangeX(end)*10^3] , [identStiffAvg*10^-9, identStiffAvg*10^-9],'b--');   % ([X1,X2],[Y1,Y2]) Ident. Avg
        plot([slice.stiffDistanceRangeX(1)*10^3,slice.stiffDistanceRangeX(end)*10^3] , [plotProperties.meanUD90_E22, plotProperties.meanUD90_E22],'red--');   % mean 90 degree tests
        plot([pos.x(1),pos.x(end)*10^3], [QS_modulus*10^-9, QS_modulus*10^-9],'k--');   % QS ref.
        plot([pos.x(1),pos.x(end)*10^3], [1.1*QS_modulus*10^-9, 1.1*QS_modulus*10^-9],'k-');   % QS ref. +10% 
        plot([pos.x(1),pos.x(end)*10^3], [0.9*QS_modulus*10^-9, 0.9*QS_modulus*10^-9],'k-');   % QS ref. -10%
        hold off
        
    elseif strcmp('Gxy',dataComponent)
        
        plot(pos.x*10^3,identStiffThreshOverL*10^-9, 'o-','Color', color.grey43);   % Plot fit coefficients to ss curves for each slice over length
        hold on
        plot(slice.stiffDistanceRangeX*10^3, identStiffThreshOverL(slice.stiffPlotRangeInd)*10^-9, 'ob-');   % Plot fit coefficients to ss curves for each slice over length
        plot([slice.stiffDistanceRangeX(1)*10^3,slice.stiffDistanceRangeX(end)*10^3] , [identStiffAvg*10^-9, identStiffAvg*10^-9],'b--');   % ([X1,X2],[Y1,Y2]) Ident. Avg
        plot([slice.stiffDistanceRangeX(1)*10^3,slice.stiffDistanceRangeX(end)*10^3] , [plotProperties.meanUD45_G12, plotProperties.meanUD45_G12],'red--');   % mean 90 degree tests
        plot([pos.x(1),pos.x(end)*10^3], [QS_modulus*10^-9, QS_modulus*10^-9],'k--');   % QS ref.
        plot([pos.x(1),pos.x(end)*10^3], [1.1*QS_modulus*10^-9, 1.1*QS_modulus*10^-9],'k-');   % QS ref. +10% 
        plot([pos.x(1),pos.x(end)*10^3], [0.9*QS_modulus*10^-9, 0.9*QS_modulus*10^-9],'k-');   % QS ref. -10%
        hold off
        
    end
       
    % Global Font Size
    globalFontSize = 12;
    
    % Grid 
    grid on
    
    % Legend
    func_legendBasic(dataComponent, globalFontSize);

    % Axis limits
    func_axisLimits(dataComponent, globalFontSize, pos.x, identStiffThreshOverL);
    
    % axis labels and properties
    func_labelStringGenerator(dataComponent, globalFontSize);
    
    % Set the figure background colour to white
    set(gcf,'color','w');
    
    % Figure size
    figureType = 'modulusVsL';
    func_figureSize(hf, figureType, switches);
       
    % Create a new directory to save the results
    savePath = [imageSavePath,'\modulusVsLength'];
        if ~exist(savePath,'dir')
            mkdir(savePath);
        end
    addpath(savePath);

    % Save file name
    saveFile = [savePath,'\',dataComponent];

    if switches.use_export_fig
        % Make images using export_fig
        export_fig(saveFile,'-png','-r400','-c[inf,inf,inf,inf]',hf);
    else
        % Make images using the print command
        print(hf,saveFile,'-dpng','-r500'); 
    end

    % Save figure as a mat file
     saveas(hf,saveFile,'fig');
    
end

