% Description of function:
% Plots strain rate vs x0
%
% Date - Version - Additions
% 26/02/2020 - first version.
% 02/03/2020 - swapped pos for slice in axisLimits. Plot for off-axis samples which use all slices.
% 16/08/2020 - export_fig
% 
% Notes: 
%
%-------------------------------------------------------------------------%

function [normSRAvg, normSRAvgMid50] = func_plotStrainRateVsL(strainNormalisedSR_VsL,...
    slice, dataComponent, imageSavePath, strainRateStrainNormalised, globalOpts)

    %----------------------------------------------------------------------
    % Switches
    switches.use_export_fig = true;
    
    %----------------------------------------------------------------------
    % Average Stiffness over threshold range for plotting (mid 50%)
    normSRAvgMid50 = round(mean(strainNormalisedSR_VsL(slice.stiffPlotRangeInd)));

    % Average Stiffness over threshold range for plotting (all slices)
    normSRAvg = round(mean(strainNormalisedSR_VsL));
   
    % color generator
    [color] = func_color;
    
    % Plot: Stiffness
    hf = figure;

    if strcmp('orthotropicReduced',globalOpts.matModel)
        plot(slice.sliceRangeX*10^3,strainNormalisedSR_VsL, 'o-','Color', color.grey43,'MarkerSize',5);   % Plot the strain-normalised strain rate per slice, against slice
        hold on
        plot([slice.sliceRangeX(1)*10^3, slice.sliceRangeX(end)*10^3] , [normSRAvg, normSRAvg],'--','Color', color.grey43);   % ([X1,X2],[Y1,Y2]) Ident. Avg    
        plot(slice.stiffDistanceRangeX*10^3, strainNormalisedSR_VsL(slice.stiffPlotRangeInd), 'o-','Color', color.green,'MarkerSize',5);   % Mid50%
        plot([slice.stiffDistanceRangeX(1)*10^3,slice.stiffDistanceRangeX(end)*10^3] , [normSRAvgMid50, normSRAvgMid50],'--','Color', color.green);   % ([X1,X2],[Y1,Y2]) Ident. Avg
        plot([slice.sliceRangeX(1),slice.sliceRangeX(end)*10^3], [strainRateStrainNormalised, strainRateStrainNormalised],'b--');   % Strain-normalised strain rate from all points.
        hold off

    elseif strcmp('orthotropicAngle',globalOpts.matModel)
        plot(slice.sliceRangeX*10^3,strainNormalisedSR_VsL, 'o-','Color', color.grey43,'MarkerSize',5);   % Plot the strain-normalised strain rate per slice, against slice
        hold on
        plot([slice.sliceRangeX(1)*10^3, slice.sliceRangeX(end)*10^3] , [normSRAvg, normSRAvg],'--','Color', color.grey43);   % ([X1,X2],[Y1,Y2]) Ident. Avg
        plot([slice.sliceRangeX(1),slice.sliceRangeX(end)*10^3], [strainRateStrainNormalised, strainRateStrainNormalised],'b--');   % Strain-normalised strain rate from all points.
        hold off

    end

    % Global Font Size
    globalFontSize = 12;
       
    % Legend
    func_legendBasic(dataComponent, globalFontSize);

    % Grid
    grid on
    
    % Axis limits
    func_axisLimits(dataComponent, globalFontSize, slice.sliceRangeX, strainNormalisedSR_VsL);
    
    % axis labels and properties
    func_labelStringGenerator(dataComponent, globalFontSize);
    
    % Figure size
    figureType = 'SR_SNorm_VsL_22';
    func_figureSize(hf, figureType, switches);
    
    % Set the figure background colour to white
    set(gcf,'color','w');
    
    %----------------------------------------------------------------------
    % Create a new directory to save the results
    savePath = [imageSavePath,'\strainNormalisedStrainRate'];
        if ~exist(savePath,'dir')
            mkdir(savePath);
        end
    addpath(savePath);

    % Save file name
    saveFile = [savePath,'\',dataComponent];

    if switches.use_export_fig
        % Make images using export_fig
        export_fig(saveFile,'-png','-r400','-c[inf,inf,inf,inf]',hf)
    else
        % Make images using the print command
        print(hf,saveFile,'-dpng','-r500'); 
    end

    % Save figure as a mat file
    saveas(hf,saveFile,'fig')
end
