% Description of function:
% Single stress-strain plot for a slice (full curve).
%
% Date - Version - Additions
% 19/07/2019 - Ver1
% 12/02/2020 - Ver2 slicex0Dist now slice.slicex0Dist to accommodate multi slice
% 06/08/2020 - Add export_fig
%
% Notes: Enter distance from free edge x0 that you want to make the main code
%
%-------------------------------------------------------------------------%

function [] = func_plotStressStrainCurveSingle(Strain, Stress,...
    dataComponent, imageSavePath, slice)


    % switches
    switches.plotSSSingleFrame = 'off'; % Options: 'on' 'off'
    switches.use_export_fig = true;

    % Plot
    hf = figure;
    plot(Strain(slice.xInd,:)*10^3, Stress(slice.xInd,:)*10^-6,'bx-'); 
    hold on
    
    % Plot single point for debugging purposes
    if strcmp('on',switches.plotSSSingleFrame)
        tempFrame = 48;
        plot(Strain(slice.xInd,tempFrame)*10^3, Stress(slice.xInd,tempFrame)*10^-6,'rx-','LineWidth',2); 
    end    

    % Grid
    grid on
    
    % Global font size
    globalFontSize = 15;
    
    % Generate plot parameters
    func_plotSSCurveParameters(dataComponent, slice, globalFontSize);
    
    % Figure Sizing
    figureType = 'ssCurveSingle';  % Define based on subplot rows x cols set at top
    func_figureSize(hf, figureType, switches);
    
    % Create a new directory to save the results
    savePath = [imageSavePath,'\ssCurves'];
        if ~exist(savePath,'dir')
            mkdir(savePath);
        end
    addpath(savePath);

    % Save file name
    saveFile = [savePath,'\',dataComponent]; %, '.bmp' '.pdf'

    if switches.use_export_fig
        % Make images using export_fig
        export_fig(saveFile,'-png','-r400','-c[0,0,0,0]',hf)
    else
        % Make images using the print command
        print(hf,saveFile,'-dpng','-r500'); 
    end

    % Save figure as a mat file
     saveas(hf,saveFile,'fig')
     
    % Close the figure windows
    close all
end