% Description of function:
% Subplot of the full stress strain curve
%
% Date - Version - Additions
% 22/07/2019 - Ver1 
%
% 06/03/2020 - Removed func_subplotParameters and changed to individual 
% functions: 
% func_axisLimits
% func_labelStringGenerator
% func_figureSize 
% 
% 06/08/2020 - removed figure sizing function, replaced with export_fig
%
% Notes: 
%-------------------------------------------------------------------------%

function [] = func_plotStressStrainCurveSubplot(Strain, Stress, ...
    dataComponent, imageSavePath, slice, time, pos, material)

    % Switches
    switches.singleAxisLabel = 0;
    switches.use_export_fig = true;

    % Setup the rows and columns for the subplot figure
    Rows = 1;
    Cols = 3;

    % Subplot over whole stress strain curve
    hf = figure;
        for xx = 1:length(slice.locXInd)
            ax(xx) = subplot(Rows, Cols, xx); % Insert subplots in plot for i=1:8
           
            plot(Strain(slice.locXInd(xx), time.tRange)*10^3,...
                Stress(slice.locXInd(xx),time.tRange)*10^-6,'-bx','LineWidth',0.5,'MarkerSize',3.8)
            hold off
            
            % Grid
            grid on
            
            % Global Font Size
            globalFontSize = 15;
            
            % Title
            func_titleSubplot(pos, slice, xx, globalFontSize);

            % Axis Limits
            func_axisLimits(dataComponent, globalFontSize, Strain, Stress, material);

            % Axis label strings
            func_labelStringGenerator(dataComponent, globalFontSize);

        end
    
        % Create a new directory to save the results
        savePath = [imageSavePath,'\ssCurves'];
            if ~exist(savePath,'dir')
                mkdir(savePath);
            end
        addpath(savePath);

        % Save file name
        saveFile = [savePath,'\',dataComponent]; %, '.bmp' '.pdf'
        
        % Figure Sizing
        figureType = 'ssCurveSubplot1x3';  % define based on subplot rows x cols set at top
        func_figureSize(hf, figureType, switches);
        
        % Set the figure background colour to white
        set(gcf,'color','w');
        
        if switches.use_export_fig
            % Make images using export_fig
            export_fig(saveFile,'-png','-r400','-c[inf,inf,inf,inf]',hf) %[top,bottom,left,right]
        else
            % Make images using the print command
            print(hf,saveFile,'-dpng','-r500'); 
        end

        % Save figure as a mat file
         saveas(hf,saveFile,'fig')
         
        % Close the figure windows
        close all

end