% Description of function:
% Finds the min strain threshold for each slice, for each frame, then finds
% the maximum compressive strain using 'min' function.
%
% Date - Version - Additions
% 08/08/2019 - Ver1 
%
% Notes: 
%-------------------------------------------------------------------------%

function [fitFrameRange] = func_strainCompOnly(...
    StrainVar, StressVar, minStrainThreshold, slice, time)

    % Find the start index (based on strain value, manual)
    for xx = 1:slice.xMaxInd
        startInd(xx) = time.tRange(1); % Define as a vector, not a matrix, starting at the first time range value.
        if minStrainThreshold ~= 0
            for tt = time.tRange(1):time.tRange(end)    % For all tRange (not total frames)
                if abs(StrainVar(xx,tt)) > abs(minStrainThreshold)
                startInd(xx) = tt;
                break;
                end
            end
        end
    end

    % Find the end index (based on max Stress)
    for xx = 1:slice.xMaxInd
        endInd(xx) = time.tRange(end); 
        [~, endInd(xx)] = max(abs(StressVar(xx,:)));
        fitFrameRange{xx} = startInd(xx):endInd(xx);  
    end

end