% Figure dimensions based on different types of figures
% 13/02/2020 ver 1
%
% Figure Types: (inset string above func_figureSize)
% 
% ssCurveSubplot1x3
% ssCurveSubplot2x6
% ssCurveSingle
% modulusVsL
%
%--------------------------------------------------------------------------

function [hf] = func_figureSize(hf, figureType, switches)
    
    %----------------------------------------------------------------------
    % Loading pulse
    
    if strcmp('loadingPulse', figureType)
            xaxisScale = 1.8;
            pbaspect([xaxisScale 1 1]);            
            paperWidth = 17; paperHeight = paperWidth/xaxisScale;  % Paper dimensions (set equal)
            imageWidth=paperWidth*1.0; imageHeight=paperHeight*0.8;
            hf_x0 = -0.5; 
            hf_y0 = 1.0;

    %--------------------------------------------------------------------------
    % SS curves

    elseif strcmp('ssCurveSubplot1x3', figureType)
        if ~switches.individualAxisLabels
            imageWidth = 33; imageHeight = 9;  % Image dimensions
            paperWidth = imageWidth-4; paperHeight = imageHeight;  % Paper dimensions
            hf_x0 = -2.0; 
            hf_y0 = 0.5;
        else
            imageWidth = 33; imageHeight = 9;  % Image dimensions
            paperWidth = imageWidth-4; paperHeight = imageHeight;  % Paper dimensions
            hf_x0 = -2.0; 
            hf_y0 = 0.5;
        end
    elseif strcmp('ssCurveSubplot2x6', figureType)
        if ~switches.individualAxisLabels
            imageWidth = 33; imageHeight = 18;  % Image dimensions
            paperWidth = imageWidth-4; paperHeight = 17.25;  % Paper dimensions
            hf_x0 = -2.0; 
            hf_y0 = -0.25;
        else
            imageWidth = 33; imageHeight = 19;  % Image dimensions
            paperWidth = imageWidth-4; paperHeight = imageHeight-2;  % Paper dimensions
            hf_x0 = -2.0; 
            hf_y0 = -1.0;
        end
    elseif strcmp('ssCurveSingle', figureType)
            imageWidth = 12; imageHeight = 10;  % Image dimensions
            paperWidth = imageWidth; paperHeight = imageHeight;  % Paper dimensions (set equal)
            hf_x0 = -0.25; 
            hf_y0 = 0;
            
    %----------------------------------------------------------------------
    % Modulus
    
    elseif strcmp('modulusVsL', figureType)
            xaxisScale = 2.4;
            pbaspect([xaxisScale 1 1]);
            imageWidth = 16; imageHeight = imageWidth/xaxisScale;
            paperWidth = imageWidth*0.95; paperHeight = 0.80*paperWidth/xaxisScale;  % Paper dimensions (set equal)
            
            hf_x0 = 0; 
            hf_y0 = 0-0.5;
    
    %----------------------------------------------------------------------
    % Normalised strain rate
    
    elseif strcmp('SR_SNorm_VsL_22', figureType)
            xaxisScale = 2.2;
            pbaspect([xaxisScale 1 1]);
            imageWidth = 20; imageHeight = imageWidth/xaxisScale;
            paperWidth = imageWidth*0.95; paperHeight = 0.88*paperWidth/xaxisScale;  % Paper dimensions (set equal)
            
            hf_x0 = 0; 
            hf_y0 = 0-0.6;
            
    %----------------------------------------------------------------------
    % Two-wave analysis
    
    elseif strcmp('twoWaveAnalysis', figureType)
            xaxisScale = 1.8;
            pbaspect([xaxisScale 1 1]);
            imageWidth = 12; imageHeight = imageWidth/xaxisScale;
            paperWidth = imageWidth*0.95; paperHeight = 1.2*(paperWidth/xaxisScale);  % Paper dimensions (set equal)
            
            hf_x0 = 0-0.1; 
            hf_y0 = 0+0.5;
    
    %----------------------------------------------------------------------
    
    else 
        fprintf('No figure size parameters defined \n');
    end
    
    %----------------------------------------------------------------------
    % Apply figure paper sizes to the handle
    
    hf = gcf;
    hf.Renderer = 'Painters';
    hf.PaperSize = ([paperWidth,paperHeight]); % Size of paper. note ratio paper/image needs to be constant
    hf.Units = 'centimeters'; 
    hf.PaperUnits = 'centimeters';
    hf.PaperPositionMode = 'manual'; %'auto','manual'.
    hf.PaperPosition = ([hf_x0, hf_y0, imageWidth, imageHeight]); % image size and location
    
end