% Description of function:
% Generate label strings
%
% Date - Version - Additions
% 04/02/2020 - Ver1 
%
% Notes: 
% 
%-------------------------------------------------------------------------%

function [] = func_labelStringGenerator(dataComponent, globalFontSize)

    % Axis (x- and y-axis properties)
    ax = gca;
    
    % X-axis Label Settings
    ax.XLabel.Interpreter = ('Latex');
    ax.XLabel.FontSize = globalFontSize;
    ax.XLabel.FontWeight = 'bold';

    % Y-axis Label Settings
    ax.YLabel.Interpreter = ('Latex');
    ax.YLabel.FontSize = globalFontSize;
    ax.YLabel.FontWeight = 'bold';

    %----------------------------------------------------------------------
    % Load pulse
    
    if strcmp('loadingPulse',dataComponent)
            
        str1 = ('Time ($\mu$s)');
        
        % right axis
        ax = gca;
        yyaxis right
        str3 = ('Stress, $\overline{\sigma_{22}}^{I}$ (MPa)');
        ax.YLabel.String = (str3);
        set(ax,'ycolor','k');
        
        % left axis
        ax = gca;
        yyaxis left
        str2 = ('Force $\overline{F_{22}}^{I}$ (kN)');
        set(ax,'ycolor','k');    
        ax.YLabel.Interpreter = ('Latex');
        ax.YLabel.FontSize = globalFontSize;
        ax.YLabel.FontWeight = 'bold';
    

    %----------------------------------------------------------------------
    % SS curves
    
    elseif strcmp('Slice1_SSCurve_full_subplot_s22', dataComponent)...
            || strcmp('SSCurve_fullandFitted_subplot_s22', dataComponent)...
            || strcmp('Slice1_SSCurve_fullandFitted_subplot_s22', dataComponent)...
            || strcmp('Slice1_SSCurve_fullandFitted_subplot_s22', dataComponent)...
            || strcmp('SSCurve_full_subplot_s22', dataComponent)...
                    
        str1 = ('Strain, $\overline{\epsilon_{22}}^{L}$ (mm.m$^{-1}$)');
        str2 = ('Stress, $\overline{\sigma_{22}}^{L}$ (MPa)');
    
    elseif strcmp('Slice1_SSCurve_full_subplot_s12', dataComponent)...
            || strcmp('Slice2_SSCurve_full_subplot_s12', dataComponent)...
            || strcmp('SSCurve_fullandFitted_subplot_s12', dataComponent)...
            || strcmp('SSCurve_fullandFittedLinearRegion_subplot_s12', dataComponent)...
            || strcmp('Slice1_SSCurve_fullandFittedLinearRegion_subplot_s12', dataComponent)...
            || strcmp('Slice2_SSCurve_fullandFittedLinearRegion_subplot_s12', dataComponent)...
            || strcmp('SSCurve_full_subplot_s12', dataComponent)...
            || strcmp('Slice1_SSCurve_fullandFitted_to10me_subplot_s12', dataComponent)...
            || strcmp('Slice2_SSCurve_fullandFitted_to10me_subplot_s12', dataComponent)
        
        str1 = ('Strain, $\overline{\gamma_{12}}^{L}$ (mm.m$^{-1}$)');
        str2 = ('Stress, $\overline{\sigma_{12}}^{L}$ (MPa)');
        
    elseif strcmp('SSCurve_fullandFitted_subplot_sxx', dataComponent)...
            || strcmp('SSCurve_fullandFitted_subplot_sxx_Q12Corr', dataComponent) 
        
        str1 = ('Strain, $\overline{\epsilon_{22}}^{L}$ (mm.m$^{-1}$)');
        str2 = ('Stress, $\overline{\sigma_{22}}^{L}$ (MPa)');
        
    elseif strcmp('SSCurve_fullandFitted_subplot_sxy', dataComponent) 
        
        str1 = ('Strain, $\overline{\gamma_{12}}^{L}$ (mm.m$^{-1}$)');
        str2 = ('Stress, $\overline{\sigma_{12}}^{L}$ (MPa)');
        
    elseif strcmp('SSCurve_fullandFitted_subplot_tracer_sxy', dataComponent) 
        
        str1 = ('Strain, $\overline{\gamma_{xy}}^{y}$ (mm.m$^{-1}$)');
        str2 = ('Stress, $\overline{\sigma_{xy}}^{y}$ (MPa)');
        
    %----------------------------------------------------------------------  
    
    elseif strcmp('progressiveModulus', dataComponent)...
            || strcmp('Slice1_progressiveModulus', dataComponent)...
            || strcmp('Slice2_progressiveModulus', dataComponent)
                    
        str1 = ('Strain, $\overline{\gamma_{12}}^{L}$ (mm.m$^{-1}$)');
        str2 = ('Modulus (GPa)');
    
    elseif strcmp('chordModulus', dataComponent)...
            || strcmp('Slice1_chordModulus', dataComponent)...
            || strcmp('Slice2_chordModulus', dataComponent)
                    
        str1 = ('Strain, $\overline{\gamma_{12}}^{L}$ (mm.m$^{-1}$)');
        str2 = ('Chord modulus (GPa)');
    
    %----------------------------------------------------------------------    
    % Modulus 
    
    elseif strcmp('Slice1_G12',dataComponent) || strcmp('Slice2_G12',dataComponent) || strcmp('G12',dataComponent)...
            || strcmp('Slice1_G12_to10me',dataComponent) || strcmp('Slice2_G12_to10me',dataComponent)...
            || strcmp('UD45_G12_multiple',dataComponent) || strcmp('MD45_G12_multiple',dataComponent)...
            || strcmp('UD90_G12_multiple',dataComponent) || strcmp('Gxy',dataComponent)
                    
        str1 = ('$x_{0}$ (mm)');
        str2 = ('$G_{12}$ (GPa)');
        
    elseif strcmp('Slice1_E22',dataComponent) || strcmp('E22',dataComponent)...
            || strcmp('UD90_E22_multiple',dataComponent) || strcmp('UD90_E22_multiple',dataComponent)...
            || strcmp('Exx',dataComponent) || strcmp('UD45_E22_multiple',dataComponent)...
            || strcmp('ExxCorr',dataComponent) || strcmp('E22Corr',dataComponent)
            
        str1 = ('$x_{0}$ (mm)');
        str2 = ('$E_{22}$ (GPa)');
    
    %----------------------------------------------------------------------    
    % Min Avg Strain rate 
    
    elseif strcmp('SR_MinAvgVsTime_22',dataComponent) 
                    
        str2 = ('Max. $|\overline{\dot{\epsilon_{22}}}|$ (s$^{-1}$)');
        str1 = ('time ($\mu$s)'); 
        
    elseif strcmp('SR_MinAvgVsTime_12',dataComponent) ...
        || strcmp('SR_MinAvgVsTime_Slice1_12',dataComponent) || strcmp('SR_MinAvgVsTime_Slice2_12',dataComponent) 
                    
        str2 = ('Max. $|\overline{\dot{\gamma_{12}}}|$ (s$^{-1}$)');
        str1 = ('time ($\mu$s)');    

    %----------------------------------------------------------------------    
    % Strain rate  Vs L
    
    elseif strcmp('SR_MinAvgVsL_22',dataComponent) 
                    
        str2 = ('Max. $|\overline{\dot{\epsilon_{22}}}|$ (s$^{-1}$)');
        str1 = ('$x_{0}$ (mm)');
        
    elseif strcmp('SR_MinAvgVsL_12',dataComponent) ...
        || strcmp('SR_MinAvgVsL_Slice1_12',dataComponent) || strcmp('SR_MinAvgVsL_Slice2_12',dataComponent) 
                    
        str2 = ('Max. $|\overline{\dot{\gamma_{12}}}|$ (s$^{-1}$)');
        str1 = ('$x_{0}$ (mm)');    

    %----------------------------------------------------------------------    
    % Normalised Strain rate 
    
    elseif strcmp('Strain_StrainRate_22',dataComponent) 
                    
        str1 = ('$\dot{\epsilon_{22}}$');
        str2 = ('$\epsilon_{22}$');
        
    elseif strcmp('Strain_StrainRate_12',dataComponent)...
        || strcmp('Strain_StrainRate_Slice1_12',dataComponent) || strcmp('Strain_StrainRate_Slice2_12',dataComponent)  
                    
        str1 = ('$\dot{\gamma_{12}}$');
        str2 = ('$\gamma_{12}$');
        
    %----------------------------------------------------------------------    
    % Strain-normalised Strain rate 
    
    elseif strcmp('SR_SNorm_VsL_22',dataComponent) || strcmp('SR_SNorm_VsL_Slice1_22',dataComponent)
                    
        str2 = ('Normalised strain rate (s$^{-1}$)');
        str1 = ('$x_{0}$ (mm)');
        
    elseif strcmp('SR_SNorm_VsL_12',dataComponent)...
        || strcmp('SR_SNorm_VsL_Slice1_12',dataComponent) || strcmp('SR_SNorm_VsL_Slice2_12',dataComponent)  
                    
        str2 = ('Normalised strain rate (s$^{-1}$)');
        str1 = ('$x_{0}$ (mm)');
    
    %----------------------------------------------------------------------    
    % Two-wave analysis 
    
    elseif strcmp('twoWaveAnalysisStrain',dataComponent) 
                    
        str1 = ('Time ($\mu$s)');
        str2 = ('Axial strain (mm/mm)');
        
    %---------------------------------------------------------------------- 
    else
        fprintf('Axis Label strings undefined \n');
        str1 = ('Property, symbol  (units)');
        str2 = ('Property, symbol (units)');
    end  
    %----------------------------------------------------------------------  
    
    % Assign the strings
    ax.XLabel.String = (str1);
    ax.YLabel.String = (str2);

end