% Plot multiple E vs. L vectors
% requires func_makeMultiVarCell executed first.
%
% 14/02/2020 - ver1
%

function func_plotStiffnessVsLMultiple(modulus_All, pos_All, numberOfTests, QS_modulus, dataComponent, savePath, sliceNo)

    % figure
    hf = figure;
    
    % switches
    switches.use_export_fig = true;

    % plot functions
    [color, colorVec] = func_color;
    
    % Markers
    [markerVec8Vars] = func_markers;
    
    %Plot loop
    for ii=1:numberOfTests
        
        if strcmp('UD90_E22_multiple', dataComponent)
            QVsL = modulus_All{ii}.identStiffThreshOverL_ExxCorrFE; % .identStiffThreshOverL_Exx
            
        elseif strcmp('UD90_G12_multiple', dataComponent)
            QVsL = modulus_All{ii}.identStiffThreshOverL_Gxy;

        elseif strcmp('UD45_E22_multiple', dataComponent)
            QVsL = modulus_All{ii}.identStiffThreshOverL_E22CorrFE; % identStiffThreshOverL_E22
        
        elseif strcmp('UD45_G12_multiple', dataComponent) || strcmp('MD45_G12_multiple', dataComponent)
            QVsL = modulus_All{ii}.identChordStiffThreshOverL_G12; % identChordStiffThreshOverL_G12
        
        end
        
        rangeTemp = 1:length(QVsL);
        pos = pos_All{ii}.x;
        stiffRangeIndTemp = modulus_All{ii}.stiffPlotRangeInd;
        stiffDistanceRangeTemp = pos(stiffRangeIndTemp);
        
        % Plot stiffness vs L
        plot(pos(rangeTemp)*10^3, QVsL*10^-9, markerVec8Vars{1,ii}, 'Color',colorVec{1,ii},'LineWidth',1.25);  % Modulus values
        hold on
        
        % Determine the mean values (mid 50% for UD90 only)
        meanStiff(ii) = mean(QVsL(stiffRangeIndTemp));
        
    end

    % Calculate the average modulus from all tests (note, not Q12 corrected value)
    meanAll = mean(meanStiff);

    % Plot means and other non-loop vars
    plot([stiffDistanceRangeTemp(1)*10^3, stiffDistanceRangeTemp(end)*10^3],[meanAll*10^-9, meanAll*10^-9],'-','Color',color.darkViolet,'LineWidth',1.25);   % ([X1,X2],[Y1,Y2]) Ident. Avg        
    plot([0,length(stiffRangeIndTemp)],[QS_modulus*10^-9, QS_modulus*10^-9],'--','Color',color.black); % QS Ref 
    plot([0,length(stiffRangeIndTemp)],[1.1*QS_modulus*10^-9, 1.1*QS_modulus*10^-9],'k-');   % QS ref. +10% 
    plot([0,length(stiffRangeIndTemp)],[0.9*QS_modulus*10^-9, 0.9*QS_modulus*10^-9],'k-');   % QS ref. -10%
    hold off
    
    % Global Font Size
    globalFontSize = 9;
    
    % Grid
    grid on
    
    % Legend
    func_legendBasic(dataComponent, globalFontSize);
    func_axisLimits(dataComponent, globalFontSize);
    func_labelStringGenerator(dataComponent, globalFontSize);
       
    % Set the figure background colour to white
    set(gcf,'color','w');

    % Figure size
    figureType = 'modulusVsL';
    func_figureSize(hf, figureType, switches);

    % Save the Figure
    saveFile = ([savePath,'\',sliceNo,'_',dataComponent]);

    if switches.use_export_fig
        % Make images using export_fig
        export_fig(saveFile,'-png','-r400','-c[inf,inf,inf,inf]',hf);
        export_fig(saveFile,'-pdf','-c[inf,inf,inf,inf]',hf);
    else
        % Make images using the print command
        print(hf,saveFile,'-dpng','-r500'); 
    end

    % Save figure as a mat file
     saveas(hf,saveFile,'fig')

end