% Plot multiple modulus vs. x0 distance histories
%
% Ver 1 - 14/02/2020
% 
% Notes: Need to specify number of tests and file name for each specimen type
% 
%--------------------------------------------------------------------------

clear all

%--------------------------------------------------------------------------
% Define the function path
funcPath = 'E:\experimentalData\ModulusPaper\plotModulusVsL_Multiple\functions';
addpath(funcPath);
addpath([funcPath,'\','Export_Fig\']);

%--------------------------------------------------------------------------
% Base path where all the experimental data is
basePath = 'E:\experimentalData\ModulusPaper';

% Save path
savePath = 'E:\experimentalData\ModulusPaper\plotModulusVsL_Multiple'; 

%--------------------------------------------------------------------------
% Mean modulus values from UD90, UD45 IBII tests in GPa.
meanE22_UD90 = 10.2e9;
meanG12_UD90 = 5.51e9;
meanE22_UD45 = 9.91e9;
meanG12_UD45 = 5.44e9;

%-------------------------------------------------------------------------%
% QS test values (Note: Q12 corrected values)
QS_E22 = 8.30e9;
QS_G12 = 4.73e9;

%% ------------------------------------------------------------------------
% UD90 - E22 

numberOfTests = 6;
subFolderName = 'UD90-S';
fileName = 'UD90_S';

for ii=1:numberOfTests
    load([basePath,'\',subFolderName,num2str(ii),'\',fileName,num2str(ii),'.mat']);
    modulus_All{ii} = verticalSlice;
    pos_All{ii} = pos;
end

% Plot 
dataComponent = 'UD90_E22_multiple';
sliceNo = 'verticalSlice';
QSModulus = QS_E22;
func_plotStiffnessVsLMultiple(modulus_All, pos_All, numberOfTests, QSModulus, dataComponent, savePath, sliceNo);


%% --------------------------------------------------------------------------
% UD90 G12

numberOfTests = 6;
subFolderName = 'UD90-S';
fileName = 'UD90_S';

for ii=1:numberOfTests
    load([basePath,'\',subFolderName,num2str(ii),'\',fileName,num2str(ii),'.mat']);
    modulus_All{ii} = verticalSlice;
    pos_All{ii} = pos;
end

% Plot  
dataComponent = 'UD90_G12_multiple';
sliceNo = 'verticalSlice';
QSModulus = QS_G12;
func_plotStiffnessVsLMultiple(modulus_All, pos_All, numberOfTests, QSModulus, dataComponent, savePath, sliceNo);

%% ------------------------------------------------------------------------
% UD45 E22 (Slice 1) 

numberOfTests = 7;
subFolderName = 'UD45-S';
fileName = 'UD45_S';

for ii=1:numberOfTests
    load([basePath,'\',subFolderName,num2str(ii),'\',fileName,num2str(ii),'.mat']);
    modulus_All{ii} = angledSlice1;
    pos_All{ii} = pos;
end

% Plot 
dataComponent = 'UD45_E22_multiple';
sliceNo = 'Slice1';
QSModulus = QS_E22;
func_plotStiffnessVsLMultiple(modulus_All, pos_All, numberOfTests, QSModulus, dataComponent, savePath, sliceNo);

%% ------------------------------------------------------------------------
% UD45 G12 (Slice 1) 

numberOfTests = 7;
subFolderName = 'UD45-S';
fileName = 'UD45_S';

for ii=1:numberOfTests
    load([basePath,'\',subFolderName,num2str(ii),'\',fileName,num2str(ii),'.mat']);
    modulus_All{ii} = chordFitSlice1;
    modulus_All{ii}.stiffPlotRangeInd = angledSlice1.stiffPlotRangeInd; % Add the slice indices from the angledSlice struct.
    pos_All{ii} = pos;
end

% Plot 
dataComponent = 'UD45_G12_multiple';
sliceNo = 'Slice1';
QSModulus = QS_G12;
func_plotStiffnessVsLMultiple(modulus_All, pos_All, numberOfTests, QSModulus, dataComponent, savePath, sliceNo);

%% ------------------------------------------------------------------------
% UD45 G12 (Slice 2) 

numberOfTests = 7;
subFolderName = 'UD45-S';
fileName = 'UD45_S';

for ii=1:numberOfTests
    load([basePath,'\',subFolderName,num2str(ii),'\',fileName,num2str(ii),'.mat']);
    modulus_All{ii} = chordFitSlice2;
    modulus_All{ii}.stiffPlotRangeInd = angledSlice2.stiffPlotRangeInd; % Add the slice indices from the angledSlice struct.
    pos_All{ii} = pos;
end

% Plot 
dataComponent = 'UD45_G12_multiple';
sliceNo = 'Slice2';
QSModulus = QS_G12;
func_plotStiffnessVsLMultiple(modulus_All, pos_All, numberOfTests, QSModulus, dataComponent, savePath, sliceNo);

%% ------------------------------------------------------------------------
% MD45 G12 (Slice 1) 

numberOfTests = 4;
subFolderName = 'MD45-S';
fileName = 'MD45_S';

for ii=1:numberOfTests
    load([basePath,'\',subFolderName,num2str(ii),'\',fileName,num2str(ii),'.mat']);
    modulus_All{ii} = chordFitSlice1; 
    modulus_All{ii}.stiffPlotRangeInd = angledSlice1.stiffPlotRangeInd; % Add the slice indices from the angledSlice struct.
    pos_All{ii} = pos;
end

% Plot 
dataComponent = 'MD45_G12_multiple';
sliceNo = 'Slice1';
QSModulus = QS_G12;
func_plotStiffnessVsLMultiple(modulus_All, pos_All, numberOfTests, QSModulus, dataComponent, savePath, sliceNo);

%% ------------------------------------------------------------------------
% MD45 G12 (Slice 2) 

numberOfTests = 4;
subFolderName = 'MD45-S';
fileName = 'MD45_S';

for ii=1:numberOfTests
    load([basePath,'\',subFolderName,num2str(ii),'\',fileName,num2str(ii),'.mat']);
    modulus_All{ii} = chordFitSlice2; 
    modulus_All{ii}.stiffPlotRangeInd = angledSlice2.stiffPlotRangeInd; % Add the slice indices from the angledSlice struct.
    pos_All{ii} = pos;
end

% Plot 
dataComponent = 'MD45_G12_multiple';
sliceNo = 'Slice2';
QSModulus = QS_G12;
func_plotStiffnessVsLMultiple(modulus_All, pos_All, numberOfTests, QSModulus, dataComponent, savePath, sliceNo);
