function [ sl ] = convfft( s, l )   % short long

% Dylan Menzies
% Fast convolution

nsl=length(s)+length(l)-1;

ns = length(s); % partition l by chunks size ns
nl = length(l);

nw = 2*ns-1;

S = fft(s, nw);

sl = zeros(1,nsl); % accumulator for result

i = 1;  % index into l

while(i <= nl)
    
    e = i + ns -1;
    if (e > nl) e = nl;  end
    c = zeros(1, ns);
    c(1:e-i+1) = l(i:e);

    C = fft(c, nw);
    cs = ifft(C .* S);

    o = sl(i:i+ns-2);
    
    cs(1:ns-1) = cs(1:ns-1) + o;  % add overlap from previous
    
    sl(i:i+2*ns-2) = cs;
    
    i = i + ns;

end


end

%  xcorr faster?
%  convolution(a, b) = xcorr(a,flip(b)) 