
% create 1/3 octave filter bank


function [filterBank, F0] = filterBank_create(Nf, NbandsPerOctave, fs)
    
    % Get centre frequencies
    %NbandsPerOctave = 6;
    d = fdesign.octave(NbandsPerOctave,'Class 1','N,F0',6,1000,44.1e3);
    F0 = validfrequencies(d);

    F0( F0 < 100 ) = [];
    F0( F0 > 20e3 ) = [];
    Nfc = length(F0);


    for n = 1:Nfc
        d = fdesign.octave(NbandsPerOctave,'Class 1', 'N,F0', Nf, F0(n), fs);
        filterBank{n} = design(d);   % H = design(D,'equiripple');
    end

end