function [mROIcrop, sROIcrop] = f_computeCommonROI_MasterSlaveCameras(RectM, mPointsX, mPointsY, RectS, sPointsX, sPointsY, refImageM, refImageS, debugOpts)
% PhotoDyn Research Group
% Date created: 14 Sept. 2018
% Author: Jared Van Blitterswyk

% This script computes the common ROI between the master and slave cameras
% to be used in processing the measured fields using the 3D formulation of
% the principal of virtual work (requires average of two fields on same
% coordinates assuming linear variation through the thickness of the
% material). The structures 'mROIcrop' and 'sROIcrop' contain the number of
% rows and columns to crop from the original field of views along all
% borders so that the resulting ROI is consistent between the two cameras

% compute ROI length, x,y coordinates of corners (master camera)
mROI.Length = round(RectM(3)); % length of ROI
mROI.Height = round(RectM(4)); % height of ROI
mROI.xTL = round(RectM(1)); % x coordinate - bottom left
mROI.yTL = round(RectM(2)); % y coordinate - bottom left
mROI.xBL = mROI.xTL; % x coordinate - top left
mROI.yBL = mROI.yTL + mROI.Height; % y coordinate - top left
mROI.xBR = mROI.xTL + mROI.Length; % x coordinate - bottom right
mROI.yBR = mROI.yBL; % y coordinate - bottom right
mROI.xTR = mROI.xBR; % x coordinate - top right
mROI.yTR = mROI.yTL; % y coordinate - top right

% coordinates of top corner of sample in master camera
mSpecimen.xTL = round(mPointsX(1));
mSpecimen.yTL = round(mPointsY(1));

% compute ROI length, x,y coordinates of corners (slave camera)
sROI.Length = round(RectS(3)); % length of ROI
sROI.Height = round(RectS(4)); % height of ROI
sROI.xTL = round(RectS(1)); % x coordinate - bottom left
sROI.yTL = round(RectS(2)); % y coordinate - bottom left
sROI.xBL = sROI.xTL; % x coordinate - top left
sROI.yBL = sROI.yTL + sROI.Height; % y coordinate - top left
sROI.xBR = sROI.xTL + sROI.Length; % x coordinate - bottom right
sROI.yBR = sROI.yBL; % y coordinate - bottom right
sROI.xTR = sROI.xBR; % x coordinate - top right
sROI.yTR = sROI.yTL; % y coordinate - top right

% coordinates of top corner of sample in slave camera
sSpecimen.xTL = round(sPointsX(1));
sSpecimen.yTL = round(sPointsY(1));

%% adjust ROI of slave to master coordinates
% find offset distance from top corner of ROI to top corner of specimen
dxROIs = sROI.xTL - sSpecimen.xTL;
dyROIs = sROI.yTL - sSpecimen.yTL;
dxROIm = mROI.xTL - mSpecimen.xTL;
dyROIm = mROI.yTL - mSpecimen.yTL;

% compute slave ROI coordinates in master camera coordinate system
s2ROI.xTL = mROI.xTL + dxROIs - dxROIm; % x coordinate - top left
s2ROI.yTL = mROI.yTL + dyROIs - dyROIm; % y coordinate - top left
s2ROI.xBL = s2ROI.xTL; % x coordinate - bottom left
s2ROI.yBL = s2ROI.yTL + sROI.Height; % y coordinate - bottom left
s2ROI.xBR = s2ROI.xTL + sROI.Length; % x coordinate - bottom right
s2ROI.yBR = s2ROI.yBL; % y coordinate - bottom right
s2ROI.xTR = s2ROI.xBR; % x coordinate - top right
s2ROI.yTR = s2ROI.yTL; % y coordinate - top right

%% calculate minimum common ROI boundaries
cROI.xBL = max(s2ROI.xBL,mROI.xBL);
cROI.yBL = min(s2ROI.yBL,mROI.yBL);
cROI.xTL = max(s2ROI.xTL,mROI.xTL);
cROI.yTL = max(s2ROI.yTL,mROI.yTL);
cROI.xBR = min(s2ROI.xBR,mROI.xBR);
cROI.yBR = min(s2ROI.yBR,mROI.yBR);
cROI.xTR = min(s2ROI.xTR,mROI.xTR);
cROI.yTR = max(s2ROI.yTR,mROI.yTR);
cROI.Length = cROI.xBR-cROI.xBL;
cROI.Height = cROI.yBL-cROI.yTL;

%% compute amount to crop from each ROI to obtain common FOV for processing
mROIcrop.colsR = abs(mROI.xBR - cROI.xBR);
mROIcrop.colsL = abs(mROI.xBL - cROI.xBL);
mROIcrop.rowsT = abs(mROI.yTL - cROI.yTL);
mROIcrop.rowsB = abs(mROI.yBL - cROI.yBL);

sROIcrop.colsR = abs(s2ROI.xBR - cROI.xBR);
sROIcrop.colsL = abs(s2ROI.xBL - cROI.xBL);
sROIcrop.rowsT = abs(s2ROI.yTL - cROI.yTL);
sROIcrop.rowsB = abs(s2ROI.yBL - cROI.yBL);

%% compute amount to crop from each ROI to obtain common FOV for processing
mROIcrop.colsR = abs(mROI.xBR - cROI.xBR);
mROIcrop.colsL = abs(mROI.xBL - cROI.xBL);
mROIcrop.rowsT = abs(mROI.yTL - cROI.yTL);
mROIcrop.rowsB = abs(mROI.yBL - cROI.yBL);

mROIC.xTL = mROI.xTL + mROIcrop.colsL;
mROIC.yTL = mROI.yTL + mROIcrop.rowsT;
mROIC.Length = mROI.Length - abs(mROIcrop.colsR) - abs(mROIcrop.colsL);
mROIC.Height = mROI.Height - abs(mROIcrop.rowsT) - abs(mROIcrop.rowsB);

sROIcrop.colsR = abs(s2ROI.xBR - cROI.xBR);
sROIcrop.colsL = abs(s2ROI.xBL - cROI.xBL);
sROIcrop.rowsT = abs(s2ROI.yTL - cROI.yTL);
sROIcrop.rowsB = abs(s2ROI.yBL - cROI.yBL);

sROIC.xTL = sROI.xTL + sROIcrop.colsL;
sROIC.yTL = sROI.yTL + sROIcrop.rowsT;
sROIC.Length = sROI.Length - abs(sROIcrop.colsR) - abs(sROIcrop.colsL);
sROIC.Height = sROI.Height - abs(sROIcrop.rowsT) - abs(sROIcrop.rowsB);

if debugOpts.showDiagnosticFigures
    % plot ROIs on separate images and both ROIs on master camera image
    figure;
    subplot(2,2,1)
    imshow(refImageM, [])
    hold on
    rectangle('Position',[mROI.xTL,mROI.yTL,mROI.Length,mROI.Height],'EdgeColor','r','LineWidth',1.5,'FaceColor',[1 0 0 0.2])
    scatter(mSpecimen.xTL,mSpecimen.yTL,'ro','LineWidth',1.5,'MarkerFaceColor',[1 1 1])
    title('Master camera ROI');
    subplot(2,2,2)
    imshow(refImageS, [])
    hold on
    rectangle('Position',[sROI.xTL,sROI.yTL,sROI.Length,sROI.Height],'EdgeColor','b','LineWidth',1.5,'FaceColor',[0 0 1 0.2])
    scatter(sSpecimen.xTL,sSpecimen.yTL,'bo','LineWidth',1.5,'MarkerFaceColor',[1 1 1])
    title('Slave camera ROI');
    subplot(2,2,3)
    imshow(refImageM, [])
    hold on
    rectangle('Position',[mROI.xTL,mROI.yTL,mROI.Length,mROI.Height],'EdgeColor','r','LineWidth',1.5,'FaceColor',[1 0 0 0.2])
    scatter(mSpecimen.xTL,mSpecimen.yTL,'ro','LineWidth',1.5,'MarkerFaceColor',[1 1 1])
    rectangle('Position',[s2ROI.xTL,s2ROI.yTL,sROI.Length,sROI.Height],'EdgeColor','b','LineWidth',1.5,'FaceColor',[0 0 1 0.2])
    scatter(sSpecimen.xTL,sSpecimen.yTL,'bo','LineWidth',1.5,'MarkerFaceColor',[1 1 1])
    title('Both ROIs on master image');

    % plot resulting common ROI between cameras
    figure;
    imshow(refImageM, [])
    hold on
    rectangle('Position',[mROI.xTL,mROI.yTL,mROI.Length,mROI.Height],'EdgeColor','r','LineWidth',1.5,'FaceColor',[1 0 0 0.2])
    scatter(mSpecimen.xTL,mSpecimen.yTL,'ro','LineWidth',1.5,'MarkerFaceColor',[1 1 1])
    rectangle('Position',[s2ROI.xTL,s2ROI.yTL,sROI.Length,sROI.Height],'EdgeColor','b','LineWidth',1.5,'FaceColor',[0 0 1 0.2])
    scatter(sSpecimen.xTL,sSpecimen.yTL,'bo','LineWidth',1.5,'MarkerFaceColor',[1 1 1])
    rectangle('Position',[cROI.xTL,cROI.yTL,cROI.Length,cROI.Height],'EdgeColor','g','LineWidth',1.5,'FaceColor',[0 1 0 0.2])
    title('Plot individual ROIs on master image and show common ROI')

    % plot cropped ROIs on original images
    % slave
    figure;
    imshow(refImageS, [])
    hold on
    rectangle('Position',[sROI.xTL,sROI.yTL,sROI.Length,sROI.Height],'EdgeColor','b','LineWidth',1.5,'FaceColor',[0 0 1 0.2])
    scatter(sSpecimen.xTL,sSpecimen.yTL,'bo','LineWidth',1.5,'MarkerFaceColor',[1 1 1])
    rectangle('Position',[sROIC.xTL,sROIC.yTL,sROIC.Length,sROIC.Height],'EdgeColor','r','LineWidth',1.5,'FaceColor',[1 0 0 0.2])
    title('cropped ROI on original image - slave')

    %master
    figure;
    imshow(refImageM, [])
    hold on
    rectangle('Position',[mROI.xTL,mROI.yTL,mROI.Length,mROI.Height],'EdgeColor','b','LineWidth',1.5,'FaceColor',[0 0 1 0.2])
    scatter(sSpecimen.xTL,sSpecimen.yTL,'bo','LineWidth',1.5,'MarkerFaceColor',[1 1 1])
    rectangle('Position',[mROIC.xTL,mROIC.yTL,mROIC.Length,mROIC.Height],'EdgeColor','r','LineWidth',1.5,'FaceColor',[1 0 0 0.2])
    title('cropped ROI on original image - master')
end
end