function [phiR,maskD] = f_correctDefects(pos,phaseMod,phi,interpMethod,ex,ey,range)
% fit mesh to original phase map - can repeat after defects removed if
% desired 

% define variable to fit (phase or modulus)
varFit = phi;
[sy,sx,st] = size(varFit.x(range.y,range.x,:));
% create mask of data to include
mask = ones(sy,sx,st);
mask(1:12,:,:) = 0;
mask(end-12:end,:,:) = 0;
mask(:,1:12,:) = 0;
mask(:,end-12:end,:) = 0;

varInterp = f_shapeFunctionInterpolant_Phase(pos,varFit,interpMethod,ex,ey,range,mask);

% compute residual and construct defect mask

residual = phi.x(range.y,range.x,:)-varInterp.x; 
threshold = std2(residual(1+13:end-13,1+13:end-13,:)); %threshold for outlier detection

% exclude border of image - edge effects of grid method
maskD.o2 = abs(residual) <= threshold;
maskD.o2(1:12,:,:) = 0;
maskD.o2(end-12:end,:,:) = 0;
maskD.o2(:,1:12,:) = 0;
maskD.o2(:,end-12:end,:) = 0;

% maskD.f = maskD.o2;
%% perform second fitting excluding defects from first fitting
varInterp2 = f_shapeFunctionInterpolant_Phase(pos,varFit,interpMethod,ex,ey,range,maskD.o2);

% compute residual and construct defect mask

frames = 1:st;
y = 1:size(range.y);
x = 1:size(range.x);
num_points = max(y)*max(x);
n = 1:num_points;

% compute residual with second fit
residual2 = phi.x(range.y,range.x,:)-varInterp2.x;

%% create a temporary variable which stores the residual, excluding the borders and any regions defined by first mask as defects
% exclude borders
temp = residual2(13:end-13,13:end-13,:);
tempM = maskD.o2(13:end-13,13:end-13,:);
% 
% temp = reshape(temp,size(temp,1)*size(temp,2),st);
tempM = reshape(tempM,size(tempM,1)*size(tempM,2),st);
% 
% xT = 1:size(temp,1)*size(temp,2);
% % exclude defects from computation of standard deviation for threshold 2
% if tempM(:,n) == 0 
%     temp(:,n) = [];
% end

threshold2 = std2(temp); %threshold for outlier detection
% maskD.f(maskD.o2 == 0) = 1;
maskD.f = abs(residual2) >= 2*threshold2;
%%
% combine masks
% if maskD.o1(y,x,frames) == 1 && maskD.o2(y,x,frames) ~=1
%     maskD.o2(y,x,frames) = 1;
% end

% exclude border of image - edge effects of grid method
maskD.f(1:12,:,:) = 0;
maskD.f(end-12:end,:,:) = 0;
maskD.f(:,1:12,:) = 0;
maskD.f(:,end-12:end,:) = 0;

% [dg_dx,dg_dy,~] = gradient(phaseMod.x,0.3/(6e03),0.3/(6e03),1);
% 
% h = figure;
% subplot(2,2,1)
% imagesc(dg_dx(range.y,range.x,25))
% axis image
% subplot(2,2,2)
% imagesc(dg_dy(range.y,range.x,50))
% axis image
% subplot(2,2,3)
% imagesc(phaseMod.x(range.y,range.x,25))
% axis image
% subplot(2,2,4)
% % imagesc(phaseMod.x(range.y,range.x,75))
imagesc(maskD.f(:,:,50))
% axis image
% subplot(2,2,1)

% [x, y] = getpts(h);
% x = floor(x);
% y = floor(y);
% 
% for i = 1:length(x)
%     maskD.o(y(i),x(i),:) = 1;
% end

maskD.e = imdilate(maskD.f==1,strel('square',6));

phiR = f_reconstructPhase(phi,maskD.e,range);

% reconstruct phase in defect regions
% phiR = f_reconstructPhase(phi,maskDefects,phiInterp,range);