function [disp,accel,strain,strainRate,grid,pos] = f_cropFieldsROI_BTB(ROIcrop, disp, accel, strain, strainRate, grid, pos)
% PhotoDyn Research Group
% Author: Jared Van Blitterswyk
% Date Created: 14 Sept. 2018

% This function crops previously processed grid data according to the
% common ROI between the master and slave camera as determined in:
% f_computeCommonROI_MasterSlaveCameras

disp.x = disp.x(1+ROIcrop.rowsT:end-ROIcrop.rowsB,1+ROIcrop.colsL:end-ROIcrop.colsR,:);
disp.y = disp.y(1+ROIcrop.rowsT:end-ROIcrop.rowsB,1+ROIcrop.colsL:end-ROIcrop.colsR,:);
% disp.rot = disp.rot(1+ROIcrop.rowsT:end-ROIcrop.rowsB,1+ROIcrop.colsL:end-ROIcrop.colsR,:);

accel.x = accel.x(1+ROIcrop.rowsT:end-ROIcrop.rowsB,1+ROIcrop.colsL:end-ROIcrop.colsR,:);
accel.y = accel.y(1+ROIcrop.rowsT:end-ROIcrop.rowsB,1+ROIcrop.colsL:end-ROIcrop.colsR,:);
accel.xAvg = func_avgFFVarOverWidth(accel.x);

strain.x = strain.x(1+ROIcrop.rowsT:end-ROIcrop.rowsB,1+ROIcrop.colsL:end-ROIcrop.colsR,:);
strain.y = strain.y(1+ROIcrop.rowsT:end-ROIcrop.rowsB,1+ROIcrop.colsL:end-ROIcrop.colsR,:);
strain.s = strain.s(1+ROIcrop.rowsT:end-ROIcrop.rowsB,1+ROIcrop.colsL:end-ROIcrop.colsR,:);
strain.xAvg = func_avgFFVarOverWidth(strain.x);
strain.yAvg = func_avgFFVarOverWidth(strain.y);

strainRate.x = strainRate.x(1+ROIcrop.rowsT:end-ROIcrop.rowsB,1+ROIcrop.colsL:end-ROIcrop.colsR,:);
strainRate.y = strainRate.y(1+ROIcrop.rowsT:end-ROIcrop.rowsB,1+ROIcrop.colsL:end-ROIcrop.colsR,:);
strainRate.s = strainRate.s(1+ROIcrop.rowsT:end-ROIcrop.rowsB,1+ROIcrop.colsL:end-ROIcrop.colsR,:);
strainRate.xAvg = func_avgFFVarOverWidth(strainRate.x);
strainRate.yAvg = func_avgFFVarOverWidth(strainRate.y);
strainRate.sAvg = func_avgFFVarOverWidth(strainRate.s);

grid.length = grid.length - grid.mPerPx*(ROIcrop.colsL + ROIcrop.colsR);
grid.height = grid.height - grid.mPerPx*(ROIcrop.rowsT + ROIcrop.rowsB);
grid.numXPeriods = grid.length/grid.pxPerPeriod;

pos.x = pos.x(1+ROIcrop.colsL:end-ROIcrop.colsR);
pos.y = pos.y(1+ROIcrop.rowsT:end-ROIcrop.rowsB);
pos.xGrid = pos.xGrid(1+ROIcrop.rowsT:end-ROIcrop.rowsB,1+ROIcrop.colsL:end-ROIcrop.colsR);
pos.yGrid = pos.yGrid(1+ROIcrop.rowsT:end-ROIcrop.rowsB,1+ROIcrop.colsL:end-ROIcrop.colsR);
end