stressT = 1:150;
strainT = 1:60;

% temp1 = squeeze(strain.sRE(250:350,15:end-15,10:90)); % longer specimen (5 px/period)
% temp2 = squeeze(stress.parabSGxy(250:350,15:end-15,10:90)); % longer specimen (5 px/period)
temp1 = squeeze(strain.sRE(1:200,15:end-15,10:60));
temp2 = squeeze(stress.parabSGxy(1:200,15:end-15,10:60));

temp1 = reshape(temp1,[],1);
temp2 = reshape(temp2,[],1);

figure;
scatter(temp1,temp2)

temp1 = round(abs(temp1)*1e03);
temp2 = round(abs(temp2)/1e06);

[X,Y] = meshgrid(strainT,stressT);
SSspace = zeros(size(X));
for i = 1:length(temp1)
    if temp1(i) <= 0
        temp1(i) = 1;
    end
    if temp2(i) <= 0
        temp2(i) = 1;
    end
    SSspace(temp2(i),temp1(i)) = SSspace(temp2(i),temp1(i)) + 1;
end

% figure;
% contourf(X(1:60,1:20),Y(1:60,1:20),SSspace(1:60,1:20),50)
% % caxis([0 15000])
% xlabel('\gamma_{xy} (mm/m)');
% ylabel('\sigma_{xy} (MPa)');
% set(gca,'FontName','Calibri Light', 'FontSize',12,'linewidth',1)
% colormap(jet)

%% refine mesh
stressT = 0:110;
strainT = 0:0.2:20;

temp1 = squeeze(strain.sRE(1:200,15:end-15,10:60));
temp2 = squeeze(stress.parabSGxy(1:200,15:end-15,10:60));

temp1 = reshape(temp1,[],1);
temp2 = reshape(temp2,[],1);

temp1_test = round(abs(temp1)*1e03,2);
temp2_test = round(abs(temp2)/1e06,2);

[X,Y] = meshgrid(strainT,stressT);
SSspace = zeros(size(X));
for i = 1:length(temp1)
    if temp1(i) <= 0
        temp1(i) = 1;
    end
    if temp2(i) <= 0
        temp2(i) = 1;
    end
    
    [~,indX] = min(abs(strainT-temp1_test(i)));
    [~,indY] = min(abs(stressT-temp2_test(i)));
    SSspace(indY,indX) = SSspace(indY,indX) + 1;
end
%%
figure;
contourf(X(1:60,1:length(strainT)),Y(1:60,1:length(strainT)),SSspace(1:60,1:length(strainT)),500)
% caxis([0 15000])
xlabel('\gamma_{xy} (mm/m)');
ylabel('\sigma_{xy} (MPa)');
set(gca,'FontName','Calibri Light', 'FontSize',12,'linewidth',1)
colormap(jet)
xlim([1,20])
ylim([1,60])

