function [ grid,pos,disp ] = f_gridMethodImageProcessing_ID(images,grid,gridMethodOpts)% UPDATE VARIABLES
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 10/8/2017
%
% Processes a sequence of grid images to obtain displacement fields
% This code uses the grid processing tool box that can be found at:
% www.thegridMethodOpts.net, developed by Grediac

%--------------------------------------------------------------------------
% 1) Load the Reference Image and Find All Images in Folder
% Get the repeated part of the string assuming underscore termination
refImage = images(:,:,1);
    
%--------------------------------------------------------------------------
% % 2) ROI for Image Processing
% specLocBottomLeft = [ceil(0.002/grid.mPerPx), ceil(0.00025/grid.mPerPx)];
% specLocTopRight = [size(refImage,2),size(refImage,1)-ceil(0.00025/grid.mPerPx)]; 
% specLocBottomLeft = [ceil(0.0012571/grid.mPerPx)+2, ceil(0.00011786/grid.mPerPx)+2]; % x/L = 1.0
specLocBottomLeft = [ceil((0.0012571+grid.pitch)/grid.mPerPx)+1, ceil(0.00011786/grid.mPerPx)+2]; % remove FOV
specLocTopRight = [size(refImage,2)-1,size(refImage,1)-ceil(0.00011786/grid.mPerPx)-1]; 
range.x = (specLocBottomLeft(1):specLocTopRight(1));
range.y = (specLocBottomLeft(2):specLocTopRight(2));
L = max(range.x)-min(range.x);

% ------------------------ Diagnositics
% figure;
% imagesc(images(:,:,1))
% hold on
% rectangle('Position',[specLocBottomLeft(1),specLocBottomLeft(2),specLocTopRight(1)-specLocBottomLeft(1), specLocTopRight(2)-specLocBottomLeft(2)],'linewidth',2,'linestyle','--')

%--------------------------------------------------------------------------
% 4) Build the Analysis Window
%Build Window
analysisWindow = build_window(gridMethodOpts.windowFlag,...
    gridMethodOpts.windowWidth*grid.pxPerPeriod); % See documentation
% 0 = Gaussian window, default
% 1 = Bi-triangular window, localised phenom, low noise
%--------------------------------------------------------------------------
% 5) Process Images
% Pre-alloc vars for speed
[sy,sx,st] = size(images);
disp.x = zeros([sy,sx,st]); 
disp.y = zeros([sy,sx,st]);
disp.rot = zeros([sy,sx,st]);
phi.x = zeros([sy,sx,st]);
phi.y = zeros([sy,sx,st]);

% Spatial Unwrapping
% fprintf('Spatial unwrapping.\n')
for i = 1:st
    % Load the current image file
    currImage = images(:,:,i);
	    
    % Calculation of the phase and spatial phase unwrapping
    [phi.x(:,:,i),phi.y(:,:,i),phaseMod.x(:,:,i),phaseMod.y(:,:,i)] = ...
        LSA(currImage, analysisWindow, grid.pxPerPeriod);
    phi.x(:,:,i) = unwrap2D(single(phi.x(:,:,i)));
    phi.y(:,:,i) = unwrap2D(single(phi.y(:,:,i)));
end

% Temporal Unwrapping
% CAUTION: this only works for a sequence of images with small increments in
% the phase, uses average phase over the FOV to calc rigid body motion
if gridMethodOpts.temporalUnwrap
    phi.x_nuw = phi.x;
    phi.y_nuw = phi.y;
    
%     fprintf('Temporal unwrappping.\n')
    threshold = pi;
    phase = func_temporalUnwrap(phi,threshold,'field',range);

    for i = 1:size(phi.x,3)
        phi.x(:,:,i) = phi.x(:,:,i) + 2*pi*phase.x(i); 
        phi.y(:,:,i) = phi.y(:,:,i) + 2*pi*phase.y(i);
    end
end

% Calculate Displacements and Strains
disp.x = zeros(size(phi.x));
disp.y = zeros(size(phi.x));
disp.rot = zeros(size(phi.x));

% Calculate a window over which the specimen exists + an extra pitch to
% avoid nans - currently uses the range variable

% startInd = min(range.x)+FOVOpts.pxFree;
% endInd = startInd+FOV_Li;
% X Range
% if (min(range.x)-grid.pxPerPeriod) < 1
%     startInd = 1;
% else
%     startInd = min(range.x);%-grid.pxPerPeriod;
% end
if (max(range.x)+grid.pxPerPeriod) > size(phi.x,2)
    endInd = size(phi.x,2);
else
    endInd = max(range.x)+grid.pxPerPeriod;
end
startInd = min(range.x)-5*grid.pxPerPeriod;
if min(startInd) < 1
    startInd =1;
end
% startInd = min(range.x)-grid.pxPerPeriod-1;

dispRangeX1 = startInd:endInd; % update ROI iteratively
% Y Range
if (min(range.y)-grid.pxPerPeriod) < 1
    startInd = 1;
else
    startInd = min(range.y)-grid.pxPerPeriod;
end
if (max(range.y)+grid.pxPerPeriod) > size(phi.x,1)
    endInd = size(phi.x,1);
else
    endInd = max(range.y)+grid.pxPerPeriod;
end

dispRangeY1 = startInd:endInd; % update ROI iteratively
% vector storing rigid-body translation of the sample over time (used for
% updated ROI approach)
indIncX = zeros(1,size(disp.x,3));

% define coordinates for undeformed image based on region of interest for
% displacement calculation

coord.x = dispRangeX1; coord.y = dispRangeY1;
disp.x = zeros(size(phi.x)); disp.y = disp.x; disp.rot = disp.x;
[coord.xM,coord.yM] = meshgrid(coord.x,coord.y);

for i = 1:size(images,3) 
    fprintf(strcat('Computing displacement for frame ',num2str(i),'\n'));
    if strcmp(gridMethodOpts.dispROIMethod,'updateROI')
        % ------------------- iteratively extend fixed ROI code -------------------
        if i == 1
            dispRangeX = dispRangeX1; dispRangeY = dispRangeY1;
        end
        % compute displacement with initial estimate of range from previous frame
        [tempDisp.x(dispRangeY,dispRangeX,i), tempDisp.y(dispRangeY,dispRangeX,i),~,~,~, disp.rot(dispRangeY,dispRangeX,i)]...
            = calculate_U_EPS(grid.pxPerPeriod,squeeze(phi.x(dispRangeY,dispRangeX,1)),squeeze(phi.y(dispRangeY,dispRangeX,1)),...
            squeeze(phi.x(dispRangeY,dispRangeX,i)),squeeze(phi.y(dispRangeY,dispRangeX,i)),gridMethodOpts.dispCalcMethod,100); 

        % compute rigid body motion of sample from displacement map
        meanX = nanmean(nanmean(tempDisp.x(:,:,i))); % in pixels
        meanY = nanmean(nanmean(tempDisp.y(:,:,i))); % in pixels
        indIncX(i) = floor(meanX);% integer pixels (negative phase means floor rounds 'up' to next negative integer
%         indIncY(i) = floor(meanY);% integer pixels (negative phase means floor rounds 'up' to next negative integer
         % adjust the range over which phase is extracted to account for specimen motion
        dispRangeX = dispRangeX1 + indIncX(i);
        dispRangeY = dispRangeY1;% + indIncY(i);

        % re-calculate displacement in the adjusted region of interest
        [disp.x(dispRangeY,dispRangeX,i), disp.y(dispRangeY,dispRangeX,i),~,~,~, disp.rot(dispRangeY,dispRangeX,i)]...
            = calculate_U_EPS(grid.pxPerPeriod,squeeze(phi.x(dispRangeY,dispRangeX,1)),squeeze(phi.y(dispRangeY,dispRangeX,1)),...
            squeeze(phi.x(dispRangeY,dispRangeX,i)),squeeze(phi.y(dispRangeY,dispRangeX,i)),gridMethodOpts.dispCalcMethod,100);
            
    elseif strcmp(gridMethodOpts.dispROIMethod,'interpolateToUndeformed')
        % ---------- inerpolate back to undeformed reference frame-----------------
        % compute displacement in deformed image (i)  
         if i == 1
            dispRangeX = dispRangeX1; dispRangeY = dispRangeY1;
         end
        
         if i == 1
            UXO = zeros(size(phi.x,1),size(phi.x,2));
            UXO = UXO(dispRangeY,dispRangeX);
            UYO = UXO;
         else
            UXO = squeeze(uxT(:,:,i-1));
            UYO = squeeze(uyT(:,:,i-1));
         end
         
         [dispT.x(dispRangeY,dispRangeX,i), dispT.y(dispRangeY,dispRangeX,i),~,~,~, dispT.rot(dispRangeY,dispRangeX,i)]...
            = calculate_U_EPS(grid.pxPerPeriod,squeeze(phi.x(dispRangeY,dispRangeX,1)),squeeze(phi.y(dispRangeY,dispRangeX,1)),...
            squeeze(phi.x(dispRangeY,dispRangeX,i)),squeeze(phi.y(dispRangeY,dispRangeX,i)),...
            UXO,UYO,gridMethodOpts.dispCalcMethod,100);
        
        uxT(:,:,i) = dispT.x(dispRangeY,dispRangeX,i);
        uyT(:,:,i) = dispT.y(dispRangeY,dispRangeX,i);
%         
        dispT.x(isnan(dispT.x)) = 0; dispT.y(isnan(dispT.y)) = 0;
        dispT.rot(isnan(dispT.rot)) = 0;
        
        if i == 40
            display(i)
        end
%         if i == 81
%             display(i)
%         end
        if i == 1
            meanXIE(i) = 0; indIncX(i) = max(dispRangeX);
            meanXFE(i) = 0; indIncFX(i) = min(range.x)-grid.pxPerPeriod;
        else
            % find motion of impact edge within one pitch of edge of sample
            meanXIE(i) = nanmean(dispT.x(:,indIncX(i-1)-grid.pxPerPeriod,i));
            meanXFE(i) = nanmean(dispT.x(:,min(range.x),i));
            % round up to nearest integer when displacement exceeds one
            % pixel
            indIncX(i) = max(dispRangeX) + ceil(meanXIE(i));
            indIncFX(i) = min(range.x)-grid.pxPerPeriod + ceil(meanXFE(i));
            % catch incase poor data suggests displacment moves out of
            % field of view (shouldn't be needed)
            if indIncX(i) > size(dispT.x,2)
                indIncX(i) = size(dispT.x,2);
            end
        end
        
        dispRangeXM = indIncFX(i):indIncX(i);
%         dispRangeXM = max(dispRangeX)-L-grid.pxPerPeriod:indIncX(i);
        mask = zeros(size(dispT.x,1),size(dispT.x,2));
        mask(dispRangeY,dispRangeXM) = 1; % set mask = 1 inside sample

        dispT.x(:,:,i) = dispT.x(:,:,i).*mask;
        dispT.y(:,:,i) = dispT.y(:,:,i).*mask;
        dispT.rot(:,:,i) = dispT.rot(:,:,i).*mask;
        
        % replace data within one pitch of impact edge with the values
        % at 7 pixels in from free edge
        numCols = min(range.x) - indIncFX(i);
        numColsIE = size(dispT.x,2)-indIncX(i);
        
        % replace displacements on impact edge and free edge - poor data
        % grid method
%         dispT.x(:,max(dispRangeXM)-numCols+1:max(dispRangeXM),i) = repmat(dispT.x(:,max(dispRangeXM)-grid.pxPerPeriod,i),1,numCols);
%         dispT.x(:,min(dispRangeXM):min(dispRangeXM)+numCols-1,i) = repmat(dispT.x(:,min(dispRangeXM)+numCols,i),1,numCols);
        
        % replace displacements between impact edge and edge of camera to
        % avoid contamination
        % grid method
        dispT.x(:,max(dispRangeXM)+1:end,i) = repmat(dispT.x(:,max(dispRangeXM),i)*2,1,numColsIE);
        
        % ------------ function
        % function to linear interpolate data over poor data regions in
        % dispT fields
        xToFit1 = dispRangeXM(numCols+1:numCols+1+grid.pxPerPeriod);
        xToFit2 = dispRangeXM(end-numColsIE-grid.pxPerPeriod:end-numColsIE);

        xToExtrap1 = dispRangeXM(1:numCols);
        xToExtrap2 = dispRangeXM(end-numColsIE:end);

        [sy,~,~] = size(dispT.x(dispRangeY,dispRangeX,:));

        for p = 1:sy   
            % create vectors of displacements to fit
            % fit smoothed map from edges inward by fitWindow plus one pitch
            dispXToFit1 = dispT.x(p,dispRangeXM(numCols+1:numCols+1+grid.pxPerPeriod),i);
            dispXToFit2 = dispT.x(p,dispRangeXM(end-numColsIE-grid.pxPerPeriod:end-numColsIE),i);
            % - interpolate
            x1 = [ones(length(xToFit1),1) xToFit1'];
            x2 = [ones(length(xToFit2),1) xToFit2'];
            r1 = x1\dispXToFit1';
            r2 = x2\dispXToFit2';

            diff1 = dispT.x(p,dispRangeXM(numCols+1),i) - (r1(2)*xToFit1(1) + r1(1));
            diff2 = dispT.x(p,dispRangeXM(end-numColsIE),i) - (r2(2)*xToFit2(end) + r2(1));

            r1(1) = r1(1) + diff1;
            r2(1) = r2(1) + diff2;

            % evaluate function at padded coordinates
            dispT.x(p,dispRangeXM(1:numCols),i) = r1(2)*xToExtrap1 + r1(1);
            dispT.x(p,dispRangeXM(end-numColsIE:end),i) = r2(2)*xToExtrap2 + r2(1);
        end
        % ---------------- end function
%         
        if i == 100
            display(i)
        end

        % reshape displacement fields to create interpolation function
        dTx = squeeze(dispT.x(dispRangeY,dispRangeX,i));
        dTy = squeeze(dispT.y(dispRangeY,dispRangeX,i));

        % if NaNs in the field, set to zero
        dTx(isnan(dTx))=0;
        dTy(isnan(dTy))=0;
        
        % transform deformed coordinates to 'undeformed' coordinates
        coordTx = reshape(coord.xM(:,:)-dTx,[],1);
        coordTy = reshape(coord.yM(:,:)-dTy,[],1);
        
        % displacments for deformed frame in the 'undeformed' coordinates
        dX = reshape(dTx,[],1);
        dY = reshape(dTy,[],1);
        
        % create interpolation function
        % displacements from deformed image in transformed coordinates
        % (undeformed image coordinate system)
        Fx = scatteredInterpolant(coordTx,coordTy,dX);
        Fy = scatteredInterpolant(coordTx,coordTy,dY);

        % compute displacements at pixel locations in undeformed coordinates
        disp.x(dispRangeY,dispRangeX,i) = Fx(coord.xM(:,:),coord.yM(:,:));
        disp.y(dispRangeY,dispRangeX,i) = Fy(coord.xM(:,:),coord.yM(:,:));  

    else
         % ------------------------ fixed ROI approach -----------------------------
        [disp.x(dispRangeY1,dispRangeX1,i), disp.y(dispRangeY1,dispRangeX1,i),~,~,~, disp.rot(dispRangeY1,dispRangeX1,i)]...
            = calculate_U_EPS_old(grid.pxPerPeriod,squeeze(phi.x(dispRangeY1,dispRangeX1,1)),squeeze(phi.y(dispRangeY1,dispRangeX1,1)),...
            squeeze(phi.x(dispRangeY1,dispRangeX1,i)),squeeze(phi.y(dispRangeY1,dispRangeX1,i)),gridMethodOpts.dispCalcMethod,100);
    end
end
%--------------------------------------------------------------------------
% 6) Convert Displacement and Crop to ROI 
% Convert the displacement from pixels to mm
disp.x = disp.x*(grid.pitch/grid.pxPerPeriod); 
disp.y = disp.y*(grid.pitch/grid.pxPerPeriod);

% Crop the image to the ROI
if strcmp(gridMethodOpts.dispROIMethod,'updateROI')
    % update ROI based on moving sample
    disp.x = disp.x(range.y,range.x+min(indIncX),:);
    disp.y = disp.y(range.y,range.x+min(indIncX),:);
else
    disp.x = disp.x(range.y,range.x,:);
    disp.y = disp.y(range.y,range.x,:);
end

% Create the position mesh grid
pos.x = grid.mPerPx/2:grid.mPerPx:(grid.mPerPx*size(disp.x,2));
pos.y = grid.mPerPx/2:grid.mPerPx:(grid.mPerPx*size(disp.x,1));
[pos.xGrid,pos.yGrid] = meshgrid(pos.x,pos.y);
pos.xStep = grid.mPerPx;
pos.yStep = grid.mPerPx;
end