%% plotting function for through-thickness linear stress gauge processing
% must be run after the function 'm_linearStresGaugeThroughThickness'

%% stress strain curves at different positions
% load in processed data assuming constant through-thickness distribution
stress1.F = stress.MC.xAvg;
stress1.B = stress.SC.xAvg;
stress1.A = stress.A.xAvg;
strain1.F = strain.MC.xAvg;
strain1.B = strain.SC.xAvg;
strain1.A = strain.A.xAvg;
pos1 = pos;

position = [5, 2, 18, 6]; % position of figure
positionPL = [0.32 0.24 0.65 0.65]; % position of plot within figure - line plot
fontSL = 6.5; % font size of legend
fontAL = 9; % font size of axes labels

folderImages = 'E:\PhD Southampton\Papers\TT Tension - Strain\Figures\';
% figure file names
filename1 = 'StressStrainOverlay_S1_SubFigE';

% find position indices closest to same x position (x = 6, 9, 12, 15 mm)
loc1 = 6e-03; loc2 = 9e-03; loc3 = 12e-03; loc4 = 15e-03;
% specimen 1
[~,ind1_S1] = min(abs(pos1.x-loc1)); [~,ind2_S1] = min(abs(pos1.x-loc2));
[~,ind3_S1] = min(abs(pos1.x-loc3)); [~,ind4_S1] = min(abs(pos1.x-loc4));

frameS1 = 10; frameF1 = 100;

% ---------- specimen #1 -----------
f = figure('color',[1 1 1]);
set(gcf, 'Units', 'centimeters', 'Position', position);
subplot(1,4,1)
plot(strain1.F(ind1_S1,frameS1:frameF1)*1e03,stress1.F(ind1_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strain1.B(ind1_S1,frameS1:frameF1)*1e03,stress1.B(ind1_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.9,0.6])
plot(strain1.A(ind1_S1,frameS1:frameF1)*1e03,stress1.A(ind1_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.4,0.1,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.4,0.1,0.1],'markerfacecolor',[0.9,0.6,0.6])
xlim([-12 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Back','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.33','interpreter','latex','fontsize',fontAL)
xticks([-10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

subplot(1,4,2)
plot(strain1.F(ind2_S1,frameS1:frameF1)*1e03,stress1.F(ind2_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strain1.B(ind2_S1,frameS1:frameF1)*1e03,stress1.B(ind2_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.9,0.6])
plot(strain1.A(ind2_S1,frameS1:frameF1)*1e03,stress1.A(ind2_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.4,0.1,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.4,0.1,0.1],'markerfacecolor',[0.9,0.6,0.6])
xlim([-12 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Back','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.50','interpreter','latex','fontsize',fontAL)
xticks([-10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

subplot(1,4,3)
plot(strain1.F(ind3_S1,frameS1:frameF1)*1e03,stress1.F(ind3_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strain1.B(ind3_S1,frameS1:frameF1)*1e03,stress1.B(ind3_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.9,0.6])
plot(strain1.A(ind3_S1,frameS1:frameF1)*1e03,stress1.A(ind3_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.4,0.1,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.4,0.1,0.1],'markerfacecolor',[0.9,0.6,0.6])
xlim([-15 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Back','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.67','interpreter','latex','fontsize',fontAL)
xticks([-15 -10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

subplot(1,4,4)
plot(strain1.F(ind4_S1,frameS1:frameF1)*1e03,stress1.F(ind4_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strain1.B(ind4_S1,frameS1:frameF1)*1e03,stress1.B(ind4_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.9,0.6])
plot(strain1.A(ind4_S1,frameS1:frameF1)*1e03,stress1.A(ind4_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.4,0.1,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.4,0.1,0.1],'markerfacecolor',[0.9,0.6,0.6])
xlim([-15 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Back','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.83','interpreter','latex','fontsize',fontAL)
xticks([-15 -10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

%% plot axial stress and axial strain components
% ---------- specimen #1 -----------
position = [5, 2, 18, 6]; % position of figure
f = figure('color',[1 1 1]);
set(gcf, 'Units', 'centimeters', 'Position', position);
subplot(1,4,1)
plot(strainO.MC.xAvg(ind1_S1,frameS1:frameF1)*1e03,stressO.MC.xAvg(ind1_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strainO.SC.xAvg(ind1_S1,frameS1:frameF1)*1e03,stressO.SC.xAvg(ind1_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.9,0.6])
xlim([-12 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Back','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.33','interpreter','latex','fontsize',fontAL)
xticks([-10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

subplot(1,4,2)
plot(strainO.MC.xAvg(ind2_S1,frameS1:frameF1)*1e03,stressO.MC.xAvg(ind2_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strainO.SC.xAvg(ind2_S1,frameS1:frameF1)*1e03,stressO.SC.xAvg(ind2_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.9,0.6])
xlim([-12 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Back','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.50','interpreter','latex','fontsize',fontAL)
xticks([-10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

subplot(1,4,3)
plot(strainO.MC.xAvg(ind3_S1,frameS1:frameF1)*1e03,stressO.MC.xAvg(ind3_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strainO.SC.xAvg(ind3_S1,frameS1:frameF1)*1e03,stressO.SC.xAvg(ind3_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.9,0.6])
xlim([-15 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Back','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.67','interpreter','latex','fontsize',fontAL)
xticks([-15 -10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

subplot(1,4,4)
plot(strainO.MC.xAvg(ind4_S1,frameS1:frameF1)*1e03,stressO.MC.xAvg(ind4_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strainO.SC.xAvg(ind4_S1,frameS1:frameF1)*1e03,stressO.SC.xAvg(ind4_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.9,0.6])
xlim([-15 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Back','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.83','interpreter','latex','fontsize',fontAL)
xticks([-15 -10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

% ---------- specimen #1 -----------
% compare to average 
f = figure('color',[1 1 1]);
set(gcf, 'Units', 'centimeters', 'Position', position);
subplot(1,4,1)
plot(strainO.MC.xAvg(ind1_S1,frameS1:frameF1)*1e03,stressO.MC.xAvg(ind1_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strain.A.xAvg(ind1_S1,frameS1:frameF1)*1e03,stress.A.xAvg(ind1_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.4,0.1,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.4,0.1,0.1],'markerfacecolor',[0.6,0.9,0.6])
xlim([-12 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Average','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.33','interpreter','latex','fontsize',fontAL)
xticks([-10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

subplot(1,4,2)
plot(strainO.MC.xAvg(ind2_S1,frameS1:frameF1)*1e03,stressO.MC.xAvg(ind2_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strain.A.xAvg(ind2_S1,frameS1:frameF1)*1e03,stress.A.xAvg(ind2_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.4,0.1,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.4,0.1,0.1],'markerfacecolor',[0.6,0.9,0.6])
xlim([-12 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Average','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.50','interpreter','latex','fontsize',fontAL)
xticks([-10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

subplot(1,4,3)
plot(strainO.MC.xAvg(ind3_S1,frameS1:frameF1)*1e03,stressO.MC.xAvg(ind3_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strain.A.xAvg(ind3_S1,frameS1:frameF1)*1e03,stress.A.xAvg(ind3_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.4,0.1,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.4,0.1,0.1],'markerfacecolor',[0.6,0.9,0.6])
xlim([-15 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Average','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.67','interpreter','latex','fontsize',fontAL)
xticks([-15 -10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

subplot(1,4,4)
plot(strainO.MC.xAvg(ind4_S1,frameS1:frameF1)*1e03,stressO.MC.xAvg(ind4_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strainO.SC.xAvg(ind4_S1,frameS1:frameF1)*1e03,stressO.SC.xAvg(ind4_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.4,0.1,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.4,0.1,0.1],'markerfacecolor',[0.6,0.9,0.6])
xlim([-15 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Average','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.83','interpreter','latex','fontsize',fontAL)
xticks([-15 -10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];


% flexural strain components
% ---------- specimen #1 -----------
f = figure('color',[1 1 1]);
set(gcf, 'Units', 'centimeters', 'Position', position);
subplot(1,4,1)
plot(strainF.MC.xAvg(ind1_S1,frameS1:frameF1)*1e03,stressF.MC.xAvg(ind1_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strainF.SC.xAvg(ind1_S1,frameS1:frameF1)*1e03,stressF.SC.xAvg(ind1_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.9,0.6])
xlim([-12 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Back','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.33','interpreter','latex','fontsize',fontAL)
xticks([-10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

subplot(1,4,2)
plot(strainF.MC.xAvg(ind2_S1,frameS1:frameF1)*1e03,stressF.MC.xAvg(ind2_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strainF.SC.xAvg(ind2_S1,frameS1:frameF1)*1e03,stressF.SC.xAvg(ind2_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.9,0.6])
xlim([-12 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Back','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.50','interpreter','latex','fontsize',fontAL)
xticks([-10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

subplot(1,4,3)
plot(strainF.MC.xAvg(ind3_S1,frameS1:frameF1)*1e03,stressF.MC.xAvg(ind3_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strainF.SC.xAvg(ind3_S1,frameS1:frameF1)*1e03,stressF.SC.xAvg(ind3_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.9,0.6])
xlim([-15 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Back','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.67','interpreter','latex','fontsize',fontAL)
xticks([-15 -10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

subplot(1,4,4)
plot(strainF.MC.xAvg(ind4_S1,frameS1:frameF1)*1e03,stressF.MC.xAvg(ind4_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strainF.SC.xAvg(ind4_S1,frameS1:frameF1)*1e03,stressF.SC.xAvg(ind4_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.9,0.6])
xlim([-15 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Back','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.83','interpreter','latex','fontsize',fontAL)
xticks([-15 -10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

% total stress components
% ---------- specimen #1 -----------
f = figure('color',[1 1 1]);
set(gcf, 'Units', 'centimeters', 'Position', position);
subplot(1,4,1)
plot(strain.MC.xAvg(ind1_S1,frameS1:frameF1)*1e03,stressT.MC.xAvg(ind1_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strain.SC.xAvg(ind1_S1,frameS1:frameF1)*1e03,stressT.SC.xAvg(ind1_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.9,0.6])
xlim([-12 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Back','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.33','interpreter','latex','fontsize',fontAL)
xticks([-10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

subplot(1,4,2)
plot(strain.MC.xAvg(ind2_S1,frameS1:frameF1)*1e03,stressT.MC.xAvg(ind2_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strain.SC.xAvg(ind2_S1,frameS1:frameF1)*1e03,stressT.SC.xAvg(ind2_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.9,0.6])
xlim([-12 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Back','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.50','interpreter','latex','fontsize',fontAL)
xticks([-10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

subplot(1,4,3)
plot(strain.MC.xAvg(ind3_S1,frameS1:frameF1)*1e03,stressT.MC.xAvg(ind3_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strain.SC.xAvg(ind3_S1,frameS1:frameF1)*1e03,stressT.SC.xAvg(ind3_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.9,0.6])
xlim([-15 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Back','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.67','interpreter','latex','fontsize',fontAL)
xticks([-15 -10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];

subplot(1,4,4)
plot(strain.MC.xAvg(ind4_S1,frameS1:frameF1)*1e03,stressT.MC.xAvg(ind4_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(strain.SC.xAvg(ind4_S1,frameS1:frameF1)*1e03,stressT.SC.xAvg(ind4_S1,frameS1:frameF1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.9,0.6])
xlim([-15 12])
ylim([-150 75])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$\overline{\epsilon_{xx}}^{x} (mm\cdot m^{-1})$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y} (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Front','Back','Linear','interpreter','latex','location','southeast','fontsize',fontSL);
title('x/L = 0.83','interpreter','latex','fontsize',fontAL)
xticks([-15 -10 -5 0 5 10])
grid on
leg.ItemTokenSize = [10,10];


%% plot acceleration maps (axial and flexural)
load('E:\PhD Southampton\MATLAB\IBIITest_ProcessingToolBox_v2_3\ManuscriptColorMap.mat')
% axial acceleration maps
var = aO;
% ---------------- MASTER CAMERA ----------------------
f10 = figure('color',[1 1 1],'Units', 'centimeters', 'Position', position);
subplot(2,3,1)
imagesc(pos.x*1e03,pos.y*1e03,var.MC.x(:,:,40))
axis image
set(gca,'YDir','normal')
colormap(map)
caxis([-10e06,10e06])
c10 = colorbar;
set(gca,'FontSize',fontAL,'LineWidth',1,'ticklabelinterpreter','latex')
set(c10,'FontSize',fontAL,'Linewidth',1,'ticklabelinterpreter','latex')
xticks([0 5 10 15])
yticks([0 2 4 6 8 10])
xticklabels({'0','5','10','15'})
yticklabels({'0','2','4','6','8','10'})
xlabel('x (mm)','interpreter','latex')
ylabel('y (mm)','interpreter','latex')
title('$$a_{x}^{O}~(F)~(m\cdot s^{-2})$$ at 8 $$\mu$$s','interpreter','latex','fontsize',fontAL)

subplot(2,3,2)
imagesc(pos.x*1e03,pos.y*1e03,var.MC.x(:,:,65))
axis image
set(gca,'YDir','normal')
colormap(map)
caxis([-10e06,10e06])
c11 = colorbar;
set(gca,'FontSize',fontAL,'LineWidth',1,'ticklabelinterpreter','latex')
set(c11,'FontSize',fontAL,'Linewidth',1,'ticklabelinterpreter','latex')
xticks([0 5 10 15])
yticks([0 2 4 6 8 10])
xticklabels({'0','5','10','15'})
yticklabels({'0','2','4','6','8','10'})
xlabel('x (mm)','interpreter','latex')
ylabel('y (mm)','interpreter','latex')
title('$$a_{x}^{O}~(F)~(m\cdot s^{-2})$$ at 13 $$\mu$$s','interpreter','latex','fontsize',fontAL)

subplot(2,3,3)
imagesc(pos.x*1e03,pos.y*1e03,var.MC.x(:,:,85))
axis image
set(gca,'YDir','normal')
colormap(map)
caxis([-10e06,10e06])
c12 = colorbar;
set(gca,'FontSize',fontAL,'LineWidth',1,'ticklabelinterpreter','latex')
set(c12,'FontSize',fontAL,'Linewidth',1,'ticklabelinterpreter','latex')
xticks([0 5 10 15])
yticks([0 2 4 6 8 10])
xticklabels({'0','5','10','15'})
yticklabels({'0','2','4','6','8','10'})
xlabel('x (mm)','interpreter','latex')
ylabel('y (mm)','interpreter','latex')
title('$$a_{x}^{O}~(F)~(m\cdot s^{-2})$$ at 17 $$\mu$$s','interpreter','latex','fontsize',fontAL)

% ----------------- SLAVE CAMERA -------------------
subplot(2,3,4)
imagesc(pos.x*1e03,pos.y*1e03,var.SC.x(:,:,40))
axis image
set(gca,'YDir','normal')
colormap(map)
caxis([-10e06,10e06])
c13 = colorbar;
set(gca,'FontSize',fontAL,'LineWidth',1,'ticklabelinterpreter','latex')
set(c13,'FontSize',fontAL,'Linewidth',1,'ticklabelinterpreter','latex')
xticks([0 5 10 15])
yticks([0 2 4 6 8 10])
xticklabels({'0','5','10','15'})
yticklabels({'0','2','4','6','8','10'})
xlabel('x (mm)','interpreter','latex')
ylabel('y (mm)','interpreter','latex')
title('$$a_{x}^{O}~(B)~(m\cdot s^{-2})$$ at 8 $$\mu$$s','interpreter','latex','fontsize',fontAL)

subplot(2,3,5)
imagesc(pos.x*1e03,pos.y*1e03,var.SC.x(:,:,65))
axis image
set(gca,'YDir','normal')
colormap(map)
caxis([-10e06,10e06])
c14 = colorbar;
set(gca,'FontSize',fontAL,'LineWidth',1,'ticklabelinterpreter','latex')
set(c14,'FontSize',fontAL,'Linewidth',1,'ticklabelinterpreter','latex')
xticks([0 5 10 15])
yticks([0 2 4 6 8 10])
xticklabels({'0','5','10','15'})
yticklabels({'0','2','4','6','8','10'})
xlabel('x (mm)','interpreter','latex')
ylabel('y (mm)','interpreter','latex')
title('$$a_{x}^{O}~(B)~(m\cdot s^{-2})$$ at 13 $$\mu$$s','interpreter','latex','fontsize',fontAL)

subplot(2,3,6)
imagesc(pos.x*1e03,pos.y*1e03,var.SC.x(:,:,85))
axis image
set(gca,'YDir','normal')
colormap(map)
caxis([-10e06,10e06])
c15 = colorbar;
set(gca,'FontSize',fontAL,'LineWidth',1,'ticklabelinterpreter','latex')
set(c15,'FontSize',fontAL,'Linewidth',1,'ticklabelinterpreter','latex')
xticks([0 5 10 15])
yticks([0 2 4 6 8 10])
xticklabels({'0','5','10','15'})
yticklabels({'0','2','4','6','8','10'})
xlabel('x (mm)','interpreter','latex')
ylabel('y (mm)','interpreter','latex')
title('$$a_{x}^{O}~(B)~(m\cdot s^{-2})$$ at 17 $$\mu$$s','interpreter','latex','fontsize',fontAL)

% acceleration maps
var = aF;
% ---------------- MASTER CAMERA ----------------------
f10 = figure('color',[1 1 1],'Units', 'centimeters', 'Position', position);
subplot(2,3,1)
imagesc(pos.x*1e03,pos.y*1e03,var.MC.x(:,:,40))
axis image
set(gca,'YDir','normal')
colormap(map)
caxis([-10e06,10e06])
c10 = colorbar;
set(gca,'FontSize',fontAL,'LineWidth',1,'ticklabelinterpreter','latex')
set(c10,'FontSize',fontAL,'Linewidth',1,'ticklabelinterpreter','latex')
xticks([0 5 10 15])
yticks([0 2 4 6 8 10])
xticklabels({'0','5','10','15'})
yticklabels({'0','2','4','6','8','10'})
xlabel('x (mm)','interpreter','latex')
ylabel('y (mm)','interpreter','latex')
title('$$a_{x}^{F}~(F)~(m\cdot s^{-2})$$ at 8 $$\mu$$s','interpreter','latex','fontsize',fontAL)

subplot(2,3,2)
imagesc(pos.x*1e03,pos.y*1e03,var.MC.x(:,:,65))
axis image
set(gca,'YDir','normal')
colormap(map)
caxis([-10e06,10e06])
c11 = colorbar;
set(gca,'FontSize',fontAL,'LineWidth',1,'ticklabelinterpreter','latex')
set(c11,'FontSize',fontAL,'Linewidth',1,'ticklabelinterpreter','latex')
xticks([0 5 10 15])
yticks([0 2 4 6 8 10])
xticklabels({'0','5','10','15'})
yticklabels({'0','2','4','6','8','10'})
xlabel('x (mm)','interpreter','latex')
ylabel('y (mm)','interpreter','latex')
title('$$a_{x}^{F}~(F)~(m\cdot s^{-2})$$ at 13 $$\mu$$s','interpreter','latex','fontsize',fontAL)

subplot(2,3,3)
imagesc(pos.x*1e03,pos.y*1e03,var.MC.x(:,:,85))
axis image
set(gca,'YDir','normal')
colormap(map)
caxis([-10e06,10e06])
c12 = colorbar;
set(gca,'FontSize',fontAL,'LineWidth',1,'ticklabelinterpreter','latex')
set(c12,'FontSize',fontAL,'Linewidth',1,'ticklabelinterpreter','latex')
xticks([0 5 10 15])
yticks([0 2 4 6 8 10])
xticklabels({'0','5','10','15'})
yticklabels({'0','2','4','6','8','10'})
xlabel('x (mm)','interpreter','latex')
ylabel('y (mm)','interpreter','latex')
title('$$a_{x}^{F}~(F)~(m\cdot s^{-2})$$ at 17 $$\mu$$s','interpreter','latex','fontsize',fontAL)

% ----------------- SLAVE CAMERA -------------------
subplot(2,3,4)
imagesc(pos.x*1e03,pos.y*1e03,var.SC.x(:,:,40))
axis image
set(gca,'YDir','normal')
colormap(map)
caxis([-10e06,10e06])
c13 = colorbar;
set(gca,'FontSize',fontAL,'LineWidth',1,'ticklabelinterpreter','latex')
set(c13,'FontSize',fontAL,'Linewidth',1,'ticklabelinterpreter','latex')
xticks([0 5 10 15])
yticks([0 2 4 6 8 10])
xticklabels({'0','5','10','15'})
yticklabels({'0','2','4','6','8','10'})
xlabel('x (mm)','interpreter','latex')
ylabel('y (mm)','interpreter','latex')
title('$$a_{x}^{F}~(B)~(m\cdot s^{-2})$$ at 8 $$\mu$$s','interpreter','latex','fontsize',fontAL)

subplot(2,3,5)
imagesc(pos.x*1e03,pos.y*1e03,var.SC.x(:,:,65))
axis image
set(gca,'YDir','normal')
colormap(map)
caxis([-10e06,10e06])
c14 = colorbar;
set(gca,'FontSize',fontAL,'LineWidth',1,'ticklabelinterpreter','latex')
set(c14,'FontSize',fontAL,'Linewidth',1,'ticklabelinterpreter','latex')
xticks([0 5 10 15])
yticks([0 2 4 6 8 10])
xticklabels({'0','5','10','15'})
yticklabels({'0','2','4','6','8','10'})
xlabel('x (mm)','interpreter','latex')
ylabel('y (mm)','interpreter','latex')
title('$$a_{x}^{F}~(B)~(m\cdot s^{-2})$$ at 13 $$\mu$$s','interpreter','latex','fontsize',fontAL)

subplot(2,3,6)
imagesc(pos.x*1e03,pos.y*1e03,var.SC.x(:,:,85))
axis image
set(gca,'YDir','normal')
colormap(map)
caxis([-10e06,10e06])
c15 = colorbar;
set(gca,'FontSize',fontAL,'LineWidth',1,'ticklabelinterpreter','latex')
set(c15,'FontSize',fontAL,'Linewidth',1,'ticklabelinterpreter','latex')
xticks([0 5 10 15])
yticks([0 2 4 6 8 10])
xticklabels({'0','5','10','15'})
yticklabels({'0','2','4','6','8','10'})
xlabel('x (mm)','interpreter','latex')
ylabel('y (mm)','interpreter','latex')
title('$$a_{x}^{F}~(B)~(m\cdot s^{-2})$$ at 17 $$\mu$$s','interpreter','latex','fontsize',fontAL)

%% plot individual fields and save to file



%% plot flexural stress along the sample at different time steps
position = [5, 2, 8.34, 6]; % position of figure
positionPL = [0.15 0.24 0.85 0.65]; % position of plot within figure - line plot
frame1 = 10;
frame2 = 30;
frame3 = 50;
frame4 = 70;
frame5 = 90;
frame6 = 100;

f = figure('color',[1 1 1]);
set(gcf, 'Units', 'centimeters', 'Position', position);
axes1 = axes('Parent',f,'Position',positionPL);
plot(pos.x*1e03,stressF.MC.xAvg(:,frame1)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(pos.x*1e03,stressF.MC.xAvg(:,frame2)/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.6,0.9])
plot(pos.x*1e03,stressF.MC.xAvg(:,frame3)/1e06,'-o','linewidth',0.5,'color',[0.4,0.1,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.4,0.1,0.1],'markerfacecolor',[0.6,0.6,0.9])
plot(pos.x*1e03,stressF.MC.xAvg(:,frame4)/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.1],'markerfacecolor',[0.6,0.6,0.9])
plot(pos.x*1e03,stressF.MC.xAvg(:,frame5)/1e06,'-o','linewidth',0.5,'color',[0.4,0.4,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.4,0.4,0.4],'markerfacecolor',[0.6,0.6,0.9])
plot(pos.x*1e03,stressF.MC.xAvg(:,frame6)/1e06,'-o','linewidth',0.5,'color',[0.7,0.7,0.7],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.7,0.7,0.7],'markerfacecolor',[0.6,0.6,0.9])
xlim([0 18])
ylim([-15 15])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$x (mm)$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y}(F) (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Frame 10','Frame 30','Frame 50','Frame 70','Frame 90','Frame 100','interpreter','latex','location','eastoutside','fontsize',fontSL);
title('Width-averaged flexural stress (Front Face)','interpreter','latex','fontsize',fontAL)
xticks([0 2 4 6 8 10 12 14 16 18])
grid on
leg.ItemTokenSize = [10,10];

f = figure('color',[1 1 1]);
set(gcf, 'Units', 'centimeters', 'Position', position);
axes1 = axes('Parent',f,'Position',positionPL);
plot(pos.x*1e03,strainF.MC.xAvg(:,frame1)*1e03,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(pos.x*1e03,strainF.MC.xAvg(:,frame2)*1e03,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.6,0.9])
plot(pos.x*1e03,strainF.MC.xAvg(:,frame3)*1e03,'-o','linewidth',0.5,'color',[0.4,0.1,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.4,0.1,0.1],'markerfacecolor',[0.6,0.6,0.9])
plot(pos.x*1e03,strainF.MC.xAvg(:,frame4)*1e03,'-o','linewidth',0.5,'color',[0.1,0.1,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.1],'markerfacecolor',[0.6,0.6,0.9])
plot(pos.x*1e03,strainF.MC.xAvg(:,frame5)*1e03,'-o','linewidth',0.5,'color',[0.4,0.4,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.4,0.4,0.4],'markerfacecolor',[0.6,0.6,0.9])
plot(pos.x*1e03,strainF.MC.xAvg(:,frame6)*1e03,'-o','linewidth',0.5,'color',[0.7,0.7,0.7],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.7,0.7,0.7],'markerfacecolor',[0.6,0.6,0.9])
xlim([0 18])
ylim([-15 15])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$x (mm)$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\sigma_{xx}}^{y}(F) (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Frame 10','Frame 30','Frame 50','Frame 70','Frame 90','Frame 100','interpreter','latex','location','eastoutside','fontsize',fontSL);
title('Width-averaged flexural strain (Front Face)','interpreter','latex','fontsize',fontAL)
xticks([0 2 4 6 8 10 12 14 16 18])
grid on
leg.ItemTokenSize = [10,10];

Ef = 9.9e09;
f = figure('color',[1 1 1]);
set(gcf, 'Units', 'centimeters', 'Position', position);
axes1 = axes('Parent',f,'Position',positionPL);
plot(pos.x*1e03,strainF.MC.xAvg(:,frame1)*Ef/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.4],'markerfacecolor',[0.6,0.6,0.9])
hold on
plot(pos.x*1e03,strainF.MC.xAvg(:,frame2)*Ef/1e06,'-o','linewidth',0.5,'color',[0.1,0.4,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.4,0.1],'markerfacecolor',[0.6,0.6,0.9])
plot(pos.x*1e03,strainF.MC.xAvg(:,frame3)*Ef/1e06,'-o','linewidth',0.5,'color',[0.4,0.1,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.4,0.1,0.1],'markerfacecolor',[0.6,0.6,0.9])
plot(pos.x*1e03,strainF.MC.xAvg(:,frame4)*Ef/1e06,'-o','linewidth',0.5,'color',[0.1,0.1,0.1],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.1,0.1,0.1],'markerfacecolor',[0.6,0.6,0.9])
plot(pos.x*1e03,strainF.MC.xAvg(:,frame5)*Ef/1e06,'-o','linewidth',0.5,'color',[0.4,0.4,0.4],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.4,0.4,0.4],'markerfacecolor',[0.6,0.6,0.9])
plot(pos.x*1e03,strainF.MC.xAvg(:,frame6)*Ef/1e06,'-o','linewidth',0.5,'color',[0.7,0.7,0.7],'linewidth',0.5,'markersize',2, 'markeredgecolor',[0.7,0.7,0.7],'markerfacecolor',[0.6,0.6,0.9])
xlim([0 18])
ylim([-80 80])
set(gca,'LineWidth',0.75);
set(gca,'FontSize',fontAL);
xlabel('$$x (mm)$$','Interpreter','latex','fontSize',fontAL);
ylabel('$$\overline{\epsilon_{xx}}^{y}(F) (MPa)$$','Interpreter','latex','fontSize',fontAL);
set(gca,'TickLabelInterpreter','latex');
leg = legend('Frame 10','Frame 30','Frame 50','Frame 70','Frame 90','Frame 100','interpreter','latex','location','eastoutside','fontsize',fontSL);
title('Theoretical Width-averaged flexural stress (Front Face)','interpreter','latex','fontsize',fontAL)
xticks([0 2 4 6 8 10 12 14 16 18])
yticks([-80 -60 -40 -20 0 20 40 60 80])
grid on
leg.ItemTokenSize = [10,10];
