%% compute strain rate via 2nd order backwards difference

for i = 1:size(strain.x,1)
    for j = 1:size(strain.x,2)
        strainRateBD.x(i,j,:) = func_backDiff(squeeze(strain.x(i,j,:)),time.step);
    end
end 

vgX = strOpts.virtualGauge.Xpx;
vgY = strOpts.virtualGauge.Ypx;

% range over which average taken
rangeX = fracture.locX-ceil(0.5*vgX):fracture.locX+ceil(0.5*vgX);
rangeY = fracture.locY-ceil(0.5*vgY):fracture.locY+ceil(0.5*vgY);

% check if range extends outside field limits and adjust if needed
if max(rangeY) > size(strainRate.x,1)
    rangeY = fracture.locY-ceil(0.5*vgY):size(strainRateBD.x,1);
elseif min(rangeY < 1)
    rangeY = 1:fracture.locY+ceil(0.5*vgY);
end

if max(rangeX) > size(strainRate.x,2)
    rangeX = fracture.locX-ceil(0.5*vgX):size(strainRateBD.x,2);
elseif min(rangeX < 1)
    rangeX = 1:fracture.locX+ceil(0.5*vgX);
end

% compute average strain over virtual gauge region
for i = 1:size(strainRate.x,3)
    strainRate_VG(i) = squeeze(mean(mean(strainRateBD.x(rangeY,rangeX,i))));
end
%%
figure;
plot(strainRate_VG(fracture.strengthFrame-10:fracture.strengthFrame+10));