function [identStiffness,linearFitCoeffs,tRange] = func_identStiffLinFitStressStrainCurve(identOpts,stressAvg,strainAvg)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 9/2/2018
%
% Linearly fits the stressAvg vs strainAvg to obtain the stiffness

% Specify the range over which the fit is performed
if strcmp(identOpts.fitRangeOpt,'componly')
    if strcmp(identOpts.fitStrainThreshold,'strainThreshold')
        [~,maxTensInd] = max(-strainAvg(:,1:100)'); % find index of maximum compressive load
    
        %allocate memory
        minInd = zeros(1,size(strainAvg,2));
        identStiffness = minInd;

        for i = 1:size(strainAvg,1)  % find index where strain closest to threshold for each position
           [~,ind] = min(abs(strainAvg(i,1:minCompInd(i))' - identOpts.strainThreshold));
            minInd(i) = ind;
        end
        for xx = 1:size(stressAvg,1)
                tRange{xx} = 1:minInd(xx);
        end

    else
        % fit to maximum strain value
        for xx = 1:size(stressAvg,1)
            [~,minInd] = min(stressAvg(xx,:));
            tRange{xx} = 10:minInd;
        end
    end
elseif strcmp(identOpts.fitRangeOpt,'tensonly')
    for xx = 1:size(stressAvg,1)
        [~,maxInd] = max(stressAvg(xx,:));
        tRange{xx} = identOpts.fitDefaultRange(1):maxInd;
    end
elseif strcmp(identOpts.fitRangeOpt,'maxabs')
    for xx = 1:size(stressAvg,1)
        [minS,minInd] = min(stressAvg(xx,:));
        [maxS,maxInd] = max(stressAvg(xx,:));

        if abs(minS) > abs(maxS)
             tRange{xx} = identOpts.fitDefaultRange(1):minInd;
        else
             tRange{xx} = identOpts.fitDefaultRange(1):maxInd;
        end
    end
else
    for xx = 1:size(stressAvg,1)
        tRange{xx} = identOpts.fitDefaultRange;
    end
end

for xx = 1:size(stressAvg,1)
    xFit = strainAvg(xx,tRange{xx});
    yFit = stressAvg(xx,tRange{xx});
    xF = [ones(length(xFit),1),xFit'];
    yF = yFit';
    regFit = xF\yF;
    identStiffness(xx) = regFit(2);
    linearFitCoeffs{xx} = [regFit(1),regFit(2)]; 
end    
end

