function func_plotFullFieldImageSeq(savePath,plotParams,labelStrs,pos,time,plotVars)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 13/3/2017
%
% Plots 2D frames of data as an image sequence
    cMap = [0 0 143
0 0 159
0 0 175
0 0 191
0 0 207
0 0 223
0 0 239
0 0 255
5 12 254
9 24 253
14 35 252
19 47 251
24 59 250
29 71 249
34 83 247
38 95 246
43 107 245
48 119 244
53 131 243
58 142 242
62 154 241
67 166 240
72 178 239
77 190 238
87 189 225
97 188 212
107 187 199
117 187 186
127 186 173
137 185 161
147 184 148
157 183 135
167 183 122
177 182 109
187 181 96
197 180 83
207 179 70
217 179 58
227 178 45
237 177 32
238 166 30
239 155 28
240 144 26
241 133 24
243 122 22
244 110 20
245 99 18
246 88 16
247 77 14
248 66 12
249 55 10 
250 44 8 
251 33 6 
253 22 4 
254 11 2 
255 0 0
239 0 0
223 0 0
207 0 0
191 0 0
175 0 0
159 0 0
143 0 0
128 0 0]/255;
    % Create a struct of formatting properties for the figure
    plotProps = func_initPlotPropsStruct(plotParams.formatType);
    
    % Specify the range of data points to plot on the image  
    if  plotParams.cutEdgePx
        rangeX = (plotParams.cutPxX+1):size(plotVars{1},2)-plotParams.cutPxX;
        rangeY = (plotParams.cutPxY+1):size(plotVars{1},1)-plotParams.cutPxY;
    else
        rangeX = 1:size(plotVars{1},2);
        rangeY = 1:size(plotVars{1},1);
    end
    
    % Check that the number of subplots and number of vars in the plot vars 
    % cell is consistent
    numPlots = length(plotVars);
    checkNumPlots = plotParams.Rows*plotParams.Cols;
    if numPlots ~= checkNumPlots
        disp('WARNING: number of plot vars is not equal to specified number of subplots.')
    end
    
    % Calculate the colorbar range for each variable to be plotted
    if isfield(plotParams,'cAxisType')
        if ~strcmp(plotParams.cAxisType,'Specified')                
            for p = 1:numPlots 
                plotParams.cRange{p} = func_calcColourBarRange(plotParams.cAxisType,...
                    plotVars{p}(rangeY,rangeX,:));
            end
        end
    end
        
    % Create and size the figure
    hf = func_createFigure(plotProps,plotParams);
    
    % Loop over each frame and plot it
    for f = 1:time.numFrames
        for p = 1:numPlots
            hold on
            % Create the subplot
            subplot(plotParams.Rows,plotParams.Cols,p)
            % Plot the image variable frame by fram
            imagesc(pos.x(rangeX)*10^3,pos.y(rangeY)*10^3,plotVars{p}(rangeY,rangeX,f))
            if isfield(plotParams,'titleFrameNum')
                if plotParams.titleFrameNum
                    titleStr = {labelStrs.t{p},[sprintf('Time: %.1f',time.vec(f)*10^6),'$\mu s$, ',sprintf('Frame: %i',f)]};
                else
                    titleStr =[labelStrs.t{p},sprintf(', Time: %.1f',time.vec(f)*10^6),'$\mu s$'];
                end
            else
                titleStr = [labelStrs.t{p},sprintf(', Time: %.1f',time.vec(f)*10^6),'$\mu s$'];
            end
            title(titleStr,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText) 
            set(gca, 'fontsize', plotProps.fs,'fontname',plotProps.ft)
            axis image
            % Create a colour bar and set the colour map
            colorbar
            colormap(cMap)
            % Determine the colour bar range 
            if isfield(plotParams,'cAxisType')
                if ~strcmp(plotParams.cAxisType,'Auto')
                    if isfield(plotParams,'cRange')
                        caxis(plotParams.cRange{p})
                    end
                end
            end
            % Remove the image axes if required
            if ~plotParams.imageAxis
                axis off
            else
                xlabel(labelStrs.x,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
                ylabel(labelStrs.y,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
            end
            hold off  
        end
        
        % Save this frame to file
        print(hf,[savePath,'\Frame_',num2str(f)],plotProps.imageSeqFormat,plotProps.imageSeqSaveRes)
        clf(hf);
    end

end

