function [stress22Avg,stress12Avg] = func_stressGaugeProcess_Ang(slice,material,specimen,time,pos,accel)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 9/2/2018
%
% Calculates stress averages along an angled slice at the material co-ord
% system angle. Angle is specified in the material.rotAngle parameter.
% NOTE: acceleration field needs to be in material co-ords. The structure
% should have the fields .mat11 and .mat22 in the material co-ords. Use the
% function func_rotateVector2D to do this.

for ff = 1:time.numFrames
    for xx = 1:slice.xMaxInd
        % Calculate the x and y co-ords of the angled slice
        [xSlice,ySlice] = func_calcAngSliceCoords(xx,pos,slice,material.rotAngle);

        % Create a logical mask for the angled slice - get all points within the
        % bounds
        for ii = 1:length(pos.y)
           sliceMask(ii,:) = pos.x < xSlice(ii);  
        end

        % Calculate the acceleration field average from the masked field
        accel11Temp = accel.mat11(:,:,ff);
        accel22Temp = accel.mat22(:,:,ff);
        
        accel11Frame = nan(length(pos.y),length(pos.x));
        accel22Frame = nan(length(pos.y),length(pos.x));
        
        accel11Frame(sliceMask) = accel11Temp(sliceMask);
        accel22Frame(sliceMask) = accel22Temp(sliceMask);
        
        accel11Masked(:,:,ff) = accel11Frame;
        accel22Masked(:,:,ff) = accel22Frame;
        
        accelSurfAvg11(xx,ff) = nanmean(accel11Frame(:));
        accelSurfAvg22(xx,ff) = nanmean(accel22Frame(:));

        % Calculate the area of the 'sliced' surface
        S = specimen.height*(pos.x(xx)+slice.lengthX/2);

        % Calculate the average stress
        stress12Avg(xx,ff) = -material.rho*S/slice.length * accelSurfAvg11(xx,ff);
        stress22Avg(xx,ff) = -material.rho*S/slice.length * accelSurfAvg22(xx,ff);

        % Reset this loop iteration
        clear sliceMask xSlice;
    end
end

end

