%% THROUGH-THICKNESS LINEAR STRESS-GAUGE (BACK-TO-BACK MEASUREMENTS)
% this code uses two rigid-body virtual fields to compute the linear
% variation of stress through-the-thickness of a sample given a set of
% displacement measurements on the front and back surface at common
% coordinates

% Date: 28 Aug. 2019
% Author: Jared Van Blitterswyk
%% -----------------------------------------------------------------------
% load in data
load('E:\PhD Southampton\Experimental Data\CFRP_TT_B2B\S1_HPVX\1-3 Plane\MTM45_13_S3_DYN\MasterAndSlaveFields_CommonFOV_S41S71T11.mat');

% load in smoothing parameters needed for processing
load('E:\PhD Southampton\Experimental Data\CFRP_TT_B2B\S1_HPVX\1-3 Plane\MTM45_13_S3_DYN\processingParameters.mat')

% add path with functions for processing
addpath('E:\PhD Southampton\MATLAB\IBIITest_ProcessingToolBox_v2_3\GlobalProcessingFunctions_2018')
%% compute displacement components due to flexure (uf) and axial (ao) loading from surface measurements
fprintf('Compute axial and flexural displacements.\n')
% axial displacements (uO)
fprintf('Axial displacements...\n')
uO.MC.x = 0.5*(disp.MC.x+disp.SC.x); uO.SC.x = uO.MC.x;
uO.MC.y = 0.5*(disp.MC.y+disp.SC.y); uO.SC.y = uO.MC.y;

% flexural displacements (uF)
fprintf('Flexural displacements...\n')
uF.MC.x = disp.MC.x-uO.MC.x; uF.SC.x = disp.SC.x-uO.SC.x;
uF.MC.y = disp.MC.y-uO.MC.y; uF.SC.y = disp.SC.y-uO.SC.y;
%% compute displacement components due to flexure (uf) and axial (ao) loading from surface measurements
fprintf('Compute axial and flexural strains.\n')
% axial strains (strainO)
fprintf('Axial strains...\n')
strainO.MC.x = 0.5*(strain.MC.x+strain.SC.x); strainO.SC.x = strainO.MC.x;

strainO.MC.xAvg = func_avgFFVarOverWidth(strainO.MC.x);  
strainO.SC.xAvg = func_avgFFVarOverWidth(strainO.SC.x);  

% flexural strains (strainF)
fprintf('Flexural strains...\n')
strainF.MC.x = strain.MC.x-strainO.MC.x; strainF.SC.x = strain.SC.x-strainO.SC.x; 

strainF.MC.xAvg = func_avgFFVarOverWidth(strainF.MC.x);  
strainF.SC.xAvg = func_avgFFVarOverWidth(strainF.SC.x);  

%% compute accelerations independently for axial and bending components
% calculate acceleration
fprintf('Calculating acceleration from the displacement fields.\n')
% axial acceleration
fprintf('Axial accelerations...\n')
[uO.MC,~,aO.MC] = func_smoothCalcAccel_BTB(time,uO.MC,smoothingOpts,diffOpts);
[uO.SC,~,aO.SC] = func_smoothCalcAccel_BTB(time,uO.SC,smoothingOpts,diffOpts);
% flexural accelerations
fprintf('Flexural accelerations...\n')
[uF.MC,~,aF.MC] = func_smoothCalcAccel_BTB(time,uF.MC,smoothingOpts,diffOpts);
[uF.SC,~,aF.SC] = func_smoothCalcAccel_BTB(time,uF.SC,smoothingOpts,diffOpts);

%% calculate axial and bending stress components with stress-gauge eq'n

fprintf('Calculating average axial (stressO) and flexural (stressF) stress from acceleration fields.\n')
% axial stress
fprintf('Axial stress...\n')
[stressO.MC.xAvg,~] = func_stressGaugeProcess(material,time,pos,aO.MC);
[stressO.SC.xAvg,~] = func_stressGaugeProcess(material,time,pos,aO.SC);

% flexural stress
fprintf('Flexural stress...\n')
[stressF.MC.xAvg,~] = func_stressGaugeProcess(material,time,pos,aF.MC);
[stressF.SC.xAvg,~] = func_stressGaugeProcess(material,time,pos,aF.SC);

% total stress front and back
fprintf('Compute total surface stress...\n')
stressT.MC.xAvg = stressO.MC.xAvg + stressF.MC.xAvg;
stressT.SC.xAvg = stressO.SC.xAvg - stressF.SC.xAvg;

fprintf('Processing Complete.\n')

%% calculate linear stress gauge fields with membrane stress
fprintf('Calculating stress with linear stress gauge for each face using Eq''n 20 and 21 (BTB Paper) .\n')
stress_BTB.MC = func_linearStressGaugeProcess_BTB(specimen,material,pos,aO.MC,aF.MC);
stress_BTB.SC = func_linearStressGaugeProcess_BTB(specimen,material,pos,aO.SC,aF.SC);