function camRes = func_calcCamResFromStaticImages(inVar,resRange,xOnly)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 6/3/2018
%
% Calculates the resolution of a variable from the processed kinematic 
% fields of a static image stack 

    if nargin < 3
        xOnly = false;
    end
    
    % Loop over each frame and calculate the standard deviation
    for tt = resRange.t
        tempVar = inVar.x(resRange.y,resRange.x,tt);
        camRes.x(tt) = std(tempVar(:));
        
        tempVar = inVar.y(resRange.y,resRange.x,tt);
        camRes.y(tt) = std(tempVar(:));
        
         % If there is shear we need to calculate the resolution here as well
        if isfield(inVar,'s')
            tempVar = inVar.s(resRange.y,resRange.x,tt);
            camRes.s(tt) = std(tempVar(:)); 
        end
    end
    
    if xOnly
        camRes.max = max(camRes.x);
    else
        if isfield(inVar,'s')
            camRes.max = max([max(camRes.x),max(camRes.y),max(camRes.s)]);
        else
            camRes.max = max([max(camRes.x),max(camRes.y)]);
        end
    end
end
    %{
     temp = disp.x(resRange.y,resRange.x,resRange.t)*10^6;
     resXCheck = std(temp(:))
    temp = disp.y(resRange.y,resRange.x,resRange.t)*10^6;
     resYCheck = std(temp(:))
%}