function strain = func_calcStrainFromDispNoSmooth(disp,xStep,yStep,extrapPixels)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 9/2/2017
%
% Calculates the strain field from the 2D displacement field

    [dux_dx,dux_dy,~] = gradient(disp.x,xStep,yStep,1);
    [duy_dx,duy_dy,~] = gradient(disp.y,xStep,yStep,1);
    strain.x = dux_dx;
    strain.y = duy_dy;
    strain.s = dux_dy(1+extrapPixels:end-extrapPixels,:,:) + duy_dx(:,1+extrapPixels:end-extrapPixels,:);

end

