function [identStiff,Rsq,indexThreshold,RsqTM,tangMod] = f_identStiffStressStrainCurve_TangentThreshold(stressAvg,strainAvg,regOpts)
% Author: Jared Van Blitterswyk
% PhotoDyn Group, University of Southampton
% Date: 9/2/2018
%
% Linearly fits the stressAvg vs strainAvg to obtain the stiffness

% loop through all positions and frames to find secant modulus and
% variation
fitHalfWidth = (regOpts.fitFrames-1)/2;

tangMod = zeros(size(strainAvg,1),regOpts.frameMax);
SSE = tangMod; % sum of squares error - describes variation of points about regression prediction
SSR = tangMod; % sum of squares regression - describes the difference between the prediction and the sample mean 
RsqTM = tangMod; % regression coefficient squared - describes the fit of the regression to the data
for x = 1:size(stressAvg,1)
    for i = fitHalfWidth+1:regOpts.frameMax
        if i > size(stressAvg,2)-fitHalfWidth
            xFit = strainAvg(x,i:end);
            yFit = stressAvg(x,i:end);
        else
            xFit = strainAvg(x,i-fitHalfWidth:i+fitHalfWidth);
            yFit = stressAvg(x,i-fitHalfWidth:i+fitHalfWidth);
        end
        xF = [ones(length(xFit),1),xFit'];
        yF = yFit';
        regFit = xF\yF;
        tangMod(x,i) = regFit(2);
        yReg = xFit*regFit(2) + regFit(1);
        SSE(x,i) = sum((yFit-yReg).^2);
        SSR(x,i) = sum((yReg - mean(yFit)).^2);
        RsqTM(x,i) = SSR(x,i)/(SSR(x,i)+SSE(x,i));
    end
end

% determine time index to threshold stress-strain based on tangent modulus
% fitting
indexThreshold = zeros(1,size(stressAvg,1));

for x = 1:size(stressAvg,1)
    tempVec = RsqTM(x,regOpts.startFrameThreshold+1:end)-regOpts.threshold;
%     temp = tempVec<0;
    temp = find(tempVec<0);
    if isempty(temp)
        indexThreshold(x) = 0;
    else
        indexThreshold(x) = temp(1);
    end
end 
indexThreshold = indexThreshold + regOpts.startFrameThreshold;

% fit stress-strain curves to thresholded data
identStiff = zeros(1,size(stressAvg,1));
Rsq = identStiff; % regression coefficient squared for identification at each point
for x = 1:size(stressAvg,1)
    xFit = strainAvg(x,1:indexThreshold(x));
    yFit = stressAvg(x,1:indexThreshold(x));
    xF = [ones(length(xFit),1),xFit'];
    yF = yFit';
    regFit = xF\yF;
    identStiff(x) = regFit(2);
    yReg = xFit*regFit(2) + regFit(1);
    SSE(x) = sum((yFit-yReg).^2);
    SSR(x) = sum((yReg - mean(yFit)).^2);
    Rsq(x) = SSR(x,i)/(SSR(x,i)+SSE(x,i));
end

end

