[sy,sx,st] = size(strain.xy);
ind1 = round(smoothingOpts.spatialKernal(1)/2); % position inwards from left edge for data reconstruction
ind2 = sx - ind1; % position inwards from right edge for data reconstruction
strain.sRE = strain.s;
% reconstruct edge shear strains
for i = 1:time.numFrames % loop through number of frames
    for j = 1:sy % loop through each position on the specimen
        temp1 = strain.s(j,ind1,i);
        temp2 = strain.s(j,ind2,i);
        slope1 = temp1/pos.x(ind1);
        slope2 = -temp2/(pos.x(end) - pos.x(ind2));
        for k = 1:ind1
            strain.sRE(j,k,i) = 0 + pos.x(k)*slope1; 
        end
        for m = ind2:sx
            strain.sRE(j,m,i) = temp2 + (pos.x(m)-pos.x(ind2))*slope2; 
        end
    end
end

for i = 1:time.numFrames % loop through number of frames 
    for j = 1:sx % loop through each position on the specimen
        stress.SGx(j,i) = mean(mean(accel.x(:,1:j,i)))*j*pos.xStep*material.rho; % line average of reconstructed stress using stress gauge approach
        strain.xnyAvg(j,i) = mean(mean(strain.x(:,j,i)+ material.nuyx*strain.y(:,j,i))); % no uniaxial stress assumption
        strain.xAvg(j,i) = mean(mean(strain.x(:,j,i))); % uniaxial stress assumption
    end
    for j = 1:sy % loop through each position on the specimen
        stress.SGxy(j,i) = nanmean(nanmean(accel.x(1:j,:,i)))*j*pos.yStep*material.rho; % line average of reconstructed stress using stress gauge approach
        stress.SGyy(j,i) = mean(mean(accel.y(1:j,:,i)))*j*pos.yStep*material.rho; % line average of reconstructed stress using stress gauge approach
        strain.xyRE_Avg(j,i) = mean(mean(strain.sRE(j,:,i)));
        strain.xyAvg(j,i) = mean(mean(strain.s(j,:,i)));
        strain.yAvg(j,i) = mean(mean(strain.y(j,:,i)));
    end
end
%% parabolic stress reconstruction
for i = 1:time.numFrames % loop through number of frames
    for j = 1:sy % loop through each position on the specimen
        stress.parabSGxy(j,:,i) = -6/(specimen.length^2)*stress.SGxy(j,i)*pos.x.*(pos.x-specimen.length); % line average of reconstructed stress using stress gauge approach
        strain.xyRE_Centre(j,i) = min(strain.sRE(j,:,i)); % peak strain for parabolic distribution\
        stress.parabSGxyMax(j,i) = squeeze(min(stress.parabSGxy(j,:,i)));
    end
end
%%
posInd = 200;
plotTimeInd = 120;
identTimeInd = 100;
% plot stress-strain curve
figure('color',[1 1 1])
plot((strain.xyAvg(posInd,1:plotTimeInd)-stressGaugeOpts.strainOffset)*1e03,stress.SGxy(posInd,1:plotTimeInd)/1e06, 'o-','color',[0.11,0.19,0.41],'linewidth',1,'markersize',4, 'markeredgecolor',[0.11,0.19,0.41],'markerfacecolor',[1 1 1])
% grid on
xlabel('$$\overline{\gamma_{xy}}^{x} (mm\cdot m^{-1}$$)','Interpreter','latex')
ylabel('$$\overline{\sigma_{xy}}^{x}$$ (MPa)','Interpreter','latex')
set(gca,'TickLabelInterpreter','latex','linewidth',1,'FontSize',16)
title('Stress-strain curve single position (average stress gauge)','Fontweight','normal','fontsize',14);
grid on
% plot stress-strain curve
figure('color',[1 1 1])
plot((strain.xyRE_Centre(posInd,1:plotTimeInd)-stressGaugeOptsP.strainOffset)*1e03,stress.parabSGxyMax(posInd,1:plotTimeInd)/1e06, 'o-','color',[0.11,0.19,0.41],'linewidth',1,'markersize',4, 'markeredgecolor',[0.11,0.19,0.41],'markerfacecolor',[1 1 1])
% grid on
xlabel('$$\gamma_{xy}(mm\cdot m^{-1}$$)','Interpreter','latex')
ylabel('$$\sigma_{xy}^{P}$$ (MPa)','Interpreter','latex')
set(gca,'TickLabelInterpreter','latex','linewidth',1,'FontSize',16)
title('Stress-strain curve single position (peak parabolic stress gauge)','Fontweight','normal','fontsize',14);
grid on
% plot stress-strain curve
% figure('color',[1 1 1])
% plot(strain.xAvg(1:timeInd,posInd)*1e03,stress.SGx(1:timeInd,posInd)/1e06)
% % grid on
% xlabel('$$\overline{\epsilon_{x}}^{x} (mm\cdot m^{-1}$$)','Interpreter','latex')
% ylabel('$$\overline{\sigma_{xx}}^{x}$$ (MPa)','Interpreter','latex')
% set(gca,'TickLabelInterpreter','latex','linewidth',1,'FontSize',16)

%% identification from stres-strain curves
[identStiffSG.QxyVsH,identStiffSG.QxyLinFitCoeffs] = ...
        func_identStiffLinFitStressStrainCurve(stressGaugeOpts,stress.SGxy(:,1:identTimeInd),strain.xyAvg(:,1:identTimeInd));
    
[identStiffSG_Parab.QxyVsH,identStiffSG_Parab.QxyLinFitCoeffs] = ...
    func_identStiffLinFitStressStrainCurve(stressGaugeOptsP,stress.parabSGxyMax(:,1:identTimeInd),strain.xyRE_Centre(:,1:identTimeInd));

% [identStiffSG_Threshold,Rsq,indexThreshold,RsqTM,tangMod] = f_identStiffStressStrainCurve_TangentThreshold(stress.parabSGxyMax,strain.xyRE_Centre,regOpts);

figure('color',[1 1 1]);
plot(pos.y(15:end-15)*1e03,identStiffSG.QxyVsH(15:end-15)/1e09, 'o-','color',[0.11,0.19,0.41],'linewidth',1,'markersize',4, 'markeredgecolor',[0.11,0.19,0.41],'markerfacecolor',[1 1 1])
hold on
plot(pos.y(15:end-15)*1e03,identStiffSG_Parab.QxyVsH(15:end-15)/1e09,  'o-','color',[0.64,0.08,0.18],'linewidth',1,'markersize',4, 'markeredgecolor',[0.64,0.08,0.18],'markerfacecolor',[1 1 1])
xlabel('$$y (mm)$$','Interpreter','latex')
ylabel('$$G_{13} (GPa)$$','Interpreter','latex')
set(gca,'TickLabelInterpreter','latex','linewidth',1,'FontSize',16)
ylim([0 15])
box on
legend('Average stress gauge','Parabolic stress gauge','location','southeast');
title('Stiffness identification along height','Fontweight','normal','fontsize',14);
grid on

figure('color',[1 1 1]);
plot(identStiffSG.QxyVsH(15:end-15)/1e09)
hold on
plot(identStiffSG_Parab.QxyVsH(15:end-15)/1e09)
title('Stiffness identification along height (Index)','Fontweight','normal','fontsize',14);
%%

%stress-gauge
figure('color',[1 1 1])
hold on
for i = 115:25:225
    plot((strain.xyAvg(i,1:plotTimeInd)-stressGaugeOpts.strainOffset)*1e03,stress.SGxy(i,1:plotTimeInd)/1e06,'linewidth',1)
end
hold off
xlabel('$$\overline{\gamma_{xy}}^{x} (mm\cdot m^{-1}$$)','Interpreter','latex')
ylabel('$$\overline{\sigma_{xy}}^{x}$$ (MPa)','Interpreter','latex')
set(gca,'TickLabelInterpreter','latex','linewidth',1,'FontSize',16)
legend('y/H = 0.50','y/H = 0.61','y/H = 0.72','y/H = 0.83','y/H = 0.93','location','northwest');
box on
title('Stress-strain curves (average stress-gauge)','Fontweight','normal','fontsize',14);
grid on
% parabolic peak stress
figure('color',[1 1 1])
hold on
for i = 115:25:225
    plot((strain.xyRE_Centre(i,1:plotTimeInd)-stressGaugeOptsP.strainOffset)*1e03,stress.parabSGxyMax(i,1:plotTimeInd)/1e06,'linewidth',1)
end
hold off
xlabel('$$\gamma_{xy}(mm\cdot m^{-1}$$)','Interpreter','latex')
ylabel('$$\sigma_{xy}^{P}$$ (MPa)','Interpreter','latex')
set(gca,'TickLabelInterpreter','latex','linewidth',1,'FontSize',16)
legend('y/H = 0.50','y/H = 0.61','y/H = 0.72','y/H = 0.83','y/H = 0.93','location','northwest');
box on
title('Stress-strain curves (peak parabolic stress-gauge)','Fontweight','normal','fontsize',14);
grid on