function [stressX,stressY,stressS] = func_calcStressFromStrain2D(strain,Q)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 8/8/2017
% Calculates the 2D stress components using the stiffness matrix
    
    [sy,sx,st] = size(strain.x);
    for t = 1:st
        for x = 1:sx
            for y = 1:sy
                stressX(y,x,t) = Q(1,1)*strain.x(y,x,t)+...
                    Q(1,2)*strain.y(y,x,t)+Q(1,3)*strain.s(y,x,t);
                
                stressY(y,x,t) = Q(2,1)*strain.x(y,x,t)+...
                    Q(2,2)*strain.y(y,x,t)+Q(2,3)*strain.s(y,x,t);
                
                stressS(y,x,t) = Q(3,1)*strain.x(y,x,t)+...
                    Q(3,2)*strain.y(y,x,t)+Q(3,3)*strain.s(y,x,t);
            end
        end
    end
end

