function hf = func_contour3Vars(plotParams,xVar,yVar,zVar)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 24/1/2018
% Creates a contour plot from 3 input vectors

plotProps = func_initPlotPropsStruct(plotParams.formatType);

xVals = unique(xVar);
yVals = unique(yVar);

for i = 1:length(zVar)
    for x = 1:length(xVals)
        for y = 1:length(yVals)
            if xVar(i) == xVals(x)  && yVar(i) == yVals(y)
                mapZ(y,x) = zVar(i);
            end
        end
    end
end

Y = yVals;
X = xVals;
Z = mapZ;

plotProps.sizePerFigXcm = plotProps.sizePerFigXcm*2;
plotProps.sizePerFigYcm = plotProps.sizePerFigYcm*2;
hf = func_createFigure(plotProps);

contourf(X,Y,Z)
colorbar
colormap(jet)
if isfield(plotParams,'cAxis')
    caxis(plotParams.cAxis)
end
title(plotParams.tStr,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'interpreter',plotParams.interpret)
xlabel(plotParams.xStr,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'interpreter',plotParams.interpret)
ylabel(plotParams.yStr,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'interpreter',plotParams.interpret)


end

