function [freeEdge,specimen,disp] = func_getFreeEdge(hardCodeFlag,imagePath,imageFile,specimen,disp)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 8/12/2017
%
% Determines which side of the reference image contains the free edge of
% the specimen for stress gauge processing

    % Create the plot properties structure
    plotProps = func_initPlotPropsStruct();
    
    if ~hardCodeFlag
        % Load the reference image into memory
        refImage = imread([imagePath,imageFile]);

        % Show the first image in the sequence
        fh = figure;
        set(fh,'Position', [plotProps.locXcm,plotProps.locYcm,...
            2*plotProps.sizePerFigXcm,2*plotProps.sizePerFigYcm])
        set(fh,'PaperPositionMode','auto')
        imshow(refImage, []);

        % Ask the user which side the free edge is on using question dialogue
        freeEdge = questdlg('Which edge is the free edge on?', ...
            'Select free edge','Left','Right','Left');

        % Close the image
        clf(fh);
        close(fh);
        specimen.freeEdge = freeEdge;
    else
        freeEdge = specimen.freeEdge;
    end

    if strcmp(freeEdge,'Right')
        % If the free edge is on the right hand side flip the displacement
        % matrix left to right
        fprintf('Free edge is on the right hand side, flipping displacement matrices\n')
        for f = 1:size(disp.x,3)
            disp.x(:,:,f) = -fliplr(disp.x(:,:,f));
            disp.y(:,:,f) = fliplr(disp.y(:,:,f));
        end
    elseif strcmp(freeEdge,'Left')
        fprintf('Free edge is on the left hand side, no correction required.\n')
    end
end