function stress = func_linearStressGaugeProcess(specimen,material,pos,accel,stress)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 31/3/2017
% Calculates the first moment of the stress gauge and caculates the axial
% stress distrbution using a linear approximation

% Get the iteration limits
[sizeY,sizeX,sizeT] = size(accel.x);

% Set the co-ord system central to the specimen
posVecX = pos.x;
posVecY = pos.y - specimen.height/2;
[posGridX,posGridY] = meshgrid(posVecX,posVecY);

% Pre-alloc for speed
ax_y = zeros(sizeY,sizeX,sizeT);
ay_x = zeros(sizeY,sizeX,sizeT);
avg_ax_y = zeros(sizeX,sizeT);
avg_ay_x = zeros(sizeX,sizeT);
avg_ay = zeros(sizeX,sizeT);

for t = 1:sizeT
    % Calculate the position weighted accleration fields for this frame
    ax_y(:,:,t) = accel.x(:,:,t).*posGridY;
    ay_x(:,:,t) = accel.y(:,:,t).*posGridX;
    
    for x = 1:sizeX
        % Calculate the surface average acceleration up to 'x'
        avg_ax_y(x,t) = mean(mean(ax_y(:,1:x,t)));
        avg_ay_x(x,t) = mean(mean(ay_x(:,1:x,t)));
        avg_ay(x,t) = mean(mean(accel.y(:,1:x,t)));
        
        % Calculate the first moment and the linear distribution of stress
        stress.xFirstMoment(x,t) = (12*material.rho*posVecX(x)/specimen.height)*...
            (avg_ax_y(x,t)-avg_ay_x(x,t)+posVecX(x)*avg_ay(x,t));
        
        for y = 1:sizeY
            stress.xLinearGauge(y,x,t) = stress.xAvg(x,t) + posVecY(y)/specimen.height...
                *stress.xFirstMoment(x,t);
        end 
    end
end


end

