function hf = func_plotStressDiffVsTime(plotParams,savePath,time,...
    stress,fracture)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 19/2/2018
%
% Plots the difference between stress measures at the fracture location vs
% time
    
    % Create path for saving the image 
    if exist(savePath,'file') ~= 7
        mkdir(savePath);
    end

    % Create a struct of formatting properties for the figure
    plotProps = func_initPlotPropsStruct(plotParams.formatType);
    plotParams.Rows = 2;
    plotParams.Cols = 2;
    
    % Calculate the width averaged stress for the strain recon stress
    stress.QRecon.xAvg = func_avgFFVarOverWidth(stress.QRecon.x);
    
    %----------------------------------------------------------------------
    % Create and size the figure
    plotProps.sizePerFigXcm = plotProps.singleColFigFactor*plotProps.sizePerFigXcm;
    hf = func_createFigure(plotProps,plotParams);
    axisScaleFact = 1.5;
    
    %----------------------------------------------------------------------
    % Width Averaged Stress Difference Subplots
    yStr = '$\overline{\sigma}$ [$MPa$]';
    subplot(plotParams.Rows,plotParams.Cols,1)
    plot(stress.xAvg(fracture.locX,:)*10^-6,...
        '-ok','linewidth',plotProps.lw,'markersize',plotProps.ms/2)
    hold on
    plot(stress.QRecon.xAvg(fracture.locX,:)*10^-6,...
        '-xb','linewidth',plotProps.lw,'markersize',plotProps.ms/2)
    hold off
    th = xlabel('Frame');
    set(th,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
    th = ylabel(yStr);
    set(th,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
    xlim([0,time.numFrames])
    ylim([round(axisScaleFact*min(stress.xAvg(fracture.locX,:)),2,'significant')...
        ,round(axisScaleFact*max(stress.xAvg(fracture.locX,:)),2,'significant')]*10^-6)
    lh = legend({'$\overline{\sigma_{SG}}$','$\overline{\sigma(\epsilon)}$'},'location','northwest');
    set(lh,'fontsize',plotProps.lfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
    set(gca, 'fontsize', plotProps.fs,'fontname',plotProps.ft)
    set(gca,'XMinorTick','on','YMinorTick','on')
    box on
    grid on
    
    widthAvgDiff = stress.xAvg(fracture.locX,:) - stress.QRecon.xAvg(fracture.locX,:);
    yStr = '$\Delta \overline{\sigma_{SG}}- \overline{\sigma(\epsilon)}$ [$MPa$]';
    subplot(plotParams.Rows,plotParams.Cols,3)
    plot(widthAvgDiff*10^-6,...
        '-or','linewidth',plotProps.lw,'markersize',plotProps.ms/2)
    th = xlabel('Frame');
    set(th,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
    th = ylabel(yStr);
    set(th,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
    xlim([0,time.numFrames])
    set(gca, 'fontsize', plotProps.fs,'fontname',plotProps.ft)
    set(gca,'XMinorTick','on','YMinorTick','on')
    box on
    grid on
    
    %----------------------------------------------------------------------
    % Area Averaged Stress Difference Subplots
    yStr = '$\overline{\sigma}^{A}$ [$MPa$]';
    subplot(plotParams.Rows,plotParams.Cols,2)
    plot(stress.virtGaugeAvg.x*10^-6,...
        '-ok','linewidth',plotProps.lw,'markersize',plotProps.ms/2)
    hold on
    plot(stress.QRecon.virtGaugeAvg.x*10^-6,...
        '-xb','linewidth',plotProps.lw,'markersize',plotProps.ms/2)
    hold off
    th = xlabel('Frame');
    set(th,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
    th = ylabel(yStr);
    set(th,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
    xlim([0,time.numFrames])
    ylim([round(axisScaleFact*min(stress.virtGaugeAvg.x),2,'significant')...
        ,round(axisScaleFact*max(stress.virtGaugeAvg.x),2,'significant')]*10^-6)
    lh = legend({'$\overline{\sigma_{SG}}^{A}$','$\overline{\sigma(\epsilon)}^{A}$'},'location','northwest');
    set(lh,'fontsize',plotProps.lfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
    set(gca, 'fontsize', plotProps.fs,'fontname',plotProps.ft)
    set(gca,'XMinorTick','on','YMinorTick','on')
    box on
    grid on
    
    stressAvgOverGaugeAreaDiff = stress.virtGaugeAvg.x - stress.QRecon.virtGaugeAvg.x;
    yStr = '$\Delta \overline{\sigma_{SG}}^{A}- \overline{\sigma(\epsilon)}^{A}$ [$MPa$]';
    subplot(plotParams.Rows,plotParams.Cols,4)
    plot(stressAvgOverGaugeAreaDiff*10^-6,...
        '-or','linewidth',plotProps.lw,'markersize',plotProps.ms/2)
    th = xlabel('Frame','fontsize',plotProps.hfs,'fontname',plotProps.ft);
    set(th,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
    th = ylabel(yStr,'fontsize',plotProps.hfs,'fontname',plotProps.ft);
    set(th,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText);
    xlim([0,time.numFrames])
    set(gca, 'fontsize', plotProps.fs,'fontname',plotProps.ft)
    set(gca,'XMinorTick','on','YMinorTick','on')
    box on
    grid on
     
end

