function hf = func_plotStressStrainCurvesGeneric(labelStrs,plotParams,pos,stressAvg,strainAvg)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 9/2/2018
%
% Plots stress strain curves at different locations on the specimen, this
% is a generic plotting function, it is up to the user to ensure the input
% stress and strain averages are consistent.

% Get the plot properties structure for  consistent formatting
plotProps = func_initPlotPropsStruct(plotParams.formatType);

% Setup the figure
hf = func_createFigure(plotProps,plotParams);

for xx = 1:length(plotParams.locXInd)
    subplot(plotParams.Rows,plotParams.Cols,xx)
    plot(strainAvg(plotParams.locXInd(xx),plotParams.tRange)*10^3,...
         stressAvg(plotParams.locXInd(xx),plotParams.tRange)*10^-6,...
                        '-+b','linewidth',plotProps.lw,'markersize',plotProps.ms)

    title(['x = ',num2str(pos.x(plotParams.locXInd(xx))*10^3),'mm'],'Interpreter',plotProps.interpText)
    xlabel(labelStrs.x,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText)
    ylabel(labelStrs.y,'fontsize',plotProps.hfs,'fontname',plotProps.ft,'Interpreter',plotProps.interpText)
    set(gca, 'fontsize', plotProps.fs,'fontname',plotProps.ft)
    set(gca,'XMinorTick','on','YMinorTick','on')
    box on
    grid on
    hold off 
end

end

