package body Controller_Package with SPARK_Mode is
   
   function HasFloorRequest(buttons_array : FLOOR_BUTTONS_ARRAY_Type;
                       first : Integer; last : Integer) return Boolean
     with Post => HasFloorRequest'Result = (for some I in buttons_array'Range =>
       first <= I and I <= last and buttons_array(I) = TRUE)
   is
   begin
      for I in buttons_array'Range loop
         if first <= I and I <= last and buttons_array(I) = TRUE then
            return TRUE;
         end if;
      end loop;
      return FALSE;
   end HasFloorRequest;

   function HasUpRequest(buttons_array : Up_BUTTONS_ARRAY_Type;
                       first : Integer; last : Integer) return Boolean
     with Post => HasUpRequest'Result = (for some I in buttons_array'Range =>
       first <= I and I <= last and buttons_array(I) = TRUE)
   is
   begin
      for I in buttons_array'Range loop
         if first <= I and I <= last and buttons_array(I) = TRUE then
            return TRUE;
         end if;
      end loop;
      return FALSE;
   end HasUpRequest;

   function HasDownRequest(buttons_array : DOWN_BUTTONS_ARRAY_Type;
                       first : Integer; last : Integer) return Boolean
     with Post => HasDownRequest'Result = (for some I in buttons_array'Range =>
       first <= I and I <= last and buttons_array(I) = TRUE)
   is
   begin
      for I in buttons_array'Range loop
         if first <= I and I <= last and buttons_array(I) = TRUE then
            return TRUE;
         end if;
      end loop;
      return FALSE;
   end HasDownRequest;

   procedure controller is
      floorRequestAbove : Boolean := HasFloorRequest(floor_buttons_array, floor + 1, TOP_FLOOR);
      floorRequestBelow : Boolean := HasFloorRequest(floor_buttons_array, 0, floor - 1);
      upRequestAbove : Boolean := HasUpRequest(up_buttons_array, floor + 1, TOP_FLOOR);
      upRequestBelow : Boolean := HasUpRequest(up_buttons_array, 0, floor - 1);
      downRequestAbove : Boolean := HasDownRequest(down_buttons_array, floor + 1, TOP_FLOOR);
      downRequestBelow : Boolean := HasDownRequest(down_buttons_array, 0, floor - 1);
   begin
      if motor = STOPPED then
         case door is
            when CLOSED =>
               if direction = UP then -- direction = Up
                  if (floor_buttons_array(floor) = TRUE or
                        (floor /= TOP_FLOOR and then up_buttons_array(floor) = TRUE))
                  then
                     DoorClosed2Half_Up;
                     Put_Line("=Controller= Door opens from Closed to Half (while going up)");
                     door_closing := False;
                  else
                     if (floorRequestAbove or upRequestAbove or downRequestAbove) then
                        MotorWinds;
                        Put_Line("=Controller= Motor starts winding");
                     else
                        if floor /= 0 and then down_buttons_array(floor) = TRUE then
                           ChangesDirectionDown_CurrentFloor;
                           Put_Line("=Controller= Changes direction to DOWN");
                        elsif (floorRequestBelow or upRequestBelow or downRequestBelow) then
                           ChangesDirectionDown_DownFloor;
                           Put_Line("=Controller= Changes direction to DOWN");
                        end if;
                     end if;
                  end if;
               else -- direction = Down
                  if (floor_buttons_array(floor) = TRUE or
                        (floor /= 0 and then down_buttons_array(floor) = TRUE))
                  then
                     DoorClosed2Half_Down;
                     Put_Line("=Controller= Door opens from Closed to Half (while going down)");
                     door_closing := False;
                  else
                     if (floorRequestBelow or upRequestBelow or downRequestBelow) then
                        MotorUnwinds;
                        Put_Line("=Controller= Motor starts unwinding");
                     else
                        if floor /= TOP_FLOOR and then up_buttons_array(floor) = TRUE then
                           ChangesDirectionUp_CurrentFloor;
                           Put_Line("=Controller= Changes direction to UP");
                        elsif (floorRequestAbove or upRequestAbove or downRequestAbove) then
                           ChangesDirectionUp_UpFloor;
                           Put_Line("=Controller= Changes direction to UP");
                        end if;
                     end if;
                  end if;
               end if;
            when OPEN =>
               DoorOpen2Half;
               Put_Line("=Controller= Door closes from Open to Half");
               door_closing := True;
            when HALF =>
               if (door_closing) then
                  if (direction = Up) then
                     if (floor_buttons_array(floor) = FALSE and then
                           (if floor /= TOP_FLOOR then up_buttons_array(floor) = FALSE))
                     then
                        DoorHalf2Closed;
                        Put_Line("=Controller= Door closes from Half to Closed");
                     else
                        DoorHalf2Open_Up;
                        Put_Line("=Controller= Door opens from Half to Open (while going up)");
                     end if;
                  else
                     if (floor_buttons_array(floor) = FALSE and then
                           (if floor /= 0 then down_buttons_array(floor) = FALSE))
                     then
                        DoorHalf2Closed;
                        Put_Line("=Controller= Door closes from Half to Closed");
                     else
                        DoorHalf2Open_Down;
                        Put_Line("=Controller= Door opens from Half to Open (while going down)");
                     end if;
                  end if;
               else
                  if (direction = Up) then
                     DoorHalf2Open_Up;
                     Put_Line("=Controller= Door opens from Half to Open (while going up)");
                  else
                     DoorHalf2Open_Down;
                     Put_Line("=Controller= Door opens from Half to Open (while going down)");
                  end if;
               end if;
         end case;
      else -- motor /= STOPPED
         if direction = UP then
            if floor_buttons_array(floor) = TRUE or
              (floor /= TOP_FLOOR and then up_buttons_array(floor) = TRUE)
            then
               MotorStopsServeRequest;
               Put_Line("=Controller= Motor stops to serve requests");
            else
               if not floorRequestAbove and not upRequestAbove and not downRequestAbove then
                  MotorStopsNoRequest;
                  Put_Line("=Controller= Motor stops (no more requests)");
               end if;
            end if;
         else -- direction = DOWN
            if floor_buttons_array(floor) = TRUE or
              (floor /= 0 and then down_buttons_array(floor) = TRUE)
            then
               MotorStopsServeRequest;
               Put_Line("=Controller= Motor stops to serve requests");
            else
               if not floorRequestBelow and not upRequestBelow and not downRequestBelow then
                  MotorStopsNoRequest;
                  Put_Line("=Controller= Motor stops (no more requests)");
               end if;
            end if;
         end if;
      end if;
   end controller;


end Controller_Package;
