with Button_Package; use Button_Package;
with Direction_Package; use Direction_Package;
with Door_Package; use Door_Package;
with Elevator; use Elevator;
with Floor_Package; use Floor_Package;
with Motor_Package; use Motor_Package;
with Ada.Text_IO; use Ada.Text_IO;
with Ada.Integer_Text_IO; use Ada.Integer_Text_IO;

package Controller_Package with SPARK_Mode is

   door_closing : Boolean := False; -- The current status of the door

   procedure controller with
     Global => (Input => (floor),
                In_Out => (File_System, door, motor, direction, floor_buttons_array,
                           up_buttons_array,
                           down_buttons_array,
                           door_closing)
               ),
       Pre => Invariants(floor,
                         direction,
                         motor,
                         door,
                         floor_buttons_array,
                         up_buttons_array,
                         down_buttons_array),
     Post => Invariants(floor,
                        direction,
                        motor,
                        door,
                        floor_buttons_array,
                        up_buttons_array,
                        down_buttons_array);

end Controller_Package;
