with Button_Package; use Button_Package;
with Direction_Package; use Direction_Package;
with Door_Package; use Door_Package;
with Elevator; use Elevator;
with Floor_Package; use Floor_Package;
with Motor_Package; use Motor_Package;
with Ada.Text_IO; use Ada.Text_IO;
with Ada.Integer_Text_IO; use Ada.Integer_Text_IO;

package User_Package with SPARK_Mode is

   procedure user with
     Global => (Input => (Default_Width,
                          Default_Base,
                          floor,
                          motor,
                          direction,
                          door),
                In_Out => (File_System,
                          floor_buttons_array,
                          up_buttons_array,
                          down_buttons_array)
               ),
       Pre => Invariants(floor,
                         direction,
                         motor,
                         door,
                         floor_buttons_array,
                         up_buttons_array,
                         down_buttons_array),
     Post => Invariants(floor,
                        direction,
                        motor,
                        door,
                        floor_buttons_array,
                        up_buttons_array,
                        down_buttons_array);
end User_Package;
