function [qo_f,Eo_f,qo_b,Eo_b,qe_f,Ee_f,neff_f,qe_b,Ee_b,neff_b] = ...
  ani_propagation(kx,ne,no,theta,phi)
%Calculates the angle of propagation and fields of the o- and e-waves 
%inside a uniaxial crystal given: 
% kx - the tangential component of the wavevectors divided by k0.
% ne, no - refractive indices of crystal
% theta, phi - polar and azimuthal angle of crsytal axis
%
% Original code: Jordan Gill
% 06/11/20
%
% If you use this code you are requested to reference this paper:
%
% J.R. Gill, E. Perivolari, M. Kaczmarek and G. D'Alessandro
% Efficient scattering model of multi-layer systems with anisotropic films
% J. Opt. Soc. Am. A (2021)
% DOI: https://doi.org/10.1364/JOSAA.416265
%
% Licensing
% =========
%
% **License**: CC BY-NC-SA
%
% This program is free software: you can redistribute it and/or modify it
% under the terms of the CC BY-NC-SA license.  This license lets you remix,
% tweak, and build upon this work non-commercially, as long as you credit
% us  and license your new creations under the identical terms.
%
% More info on the license type is available at:
%
% https://creativecommons.org/licenses/by-nc-sa/4.0/
%
% Please contact dales@soton.ac.uk if you want to use this code commercially.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

R=rot_mat(theta,phi); %rotation matrix from lab to crystal frame

%calculate the normal components of the o-waves 
qo_f=sqrt(no^2-kx.^2);
qo_b=-qo_f;

%calculate the normalised E field directions of the o waves
Eo_f=zeros(length(kx),3);
Eo_b=zeros(length(kx),3);
c=[cos(theta)*sin(phi);cos(phi);sin(theta)*sin(phi)];  %optical axis of uniaxial layer

for i=1:size(Eo_f,1)
  %forward o-wave
  k=[kx(i);0;qo_f(i)];
  E=cross(k,c);
  Eo_f(i,:)=E/norm(E);
  
  %backward o-wave
  k=[kx(i);0;qo_b(i)];
  E=cross(k,c);
  Eo_b(i,:)=E/norm(E);
end

% calculate the extraordinary waves refracted angles and refractive index - 
% using wavenormal surface
[qe_f,qe_b,neff_f,neff_b]=e_wave(theta,phi,ne,no,kx);
eps=(R)'*[no^2,0,0;0,no^2,0;0,0,ne^2]*(R);

%calculate the D field directions of the e waves
Ee_f=zeros(length(kx),3);
Ee_b=zeros(length(kx),3);
for i=1:size(Ee_f,1)
  %forward e-wave
  k=[kx(i);0;qe_f(i)];
  E=eps^-1*cross(k,cross(k,c));
  Ee_f(i,:)=E/norm(E);
  
  %backward e-wave
  k=[kx(i);0;qe_b(i)];
  E=eps^-1*cross(k,cross(k,c));
  Ee_b(i,:)=E/norm(E);
end